/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.lettuce;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.RedisClient;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.Optional;

@Internal
public class RedisConnectionUtil {
    @NonNull
    public static AbstractRedisClient findClient(BeanLocator beanLocator, Optional<String> serverName, String errorMessage) {
        Optional<RedisClusterClient> clusterConn = RedisConnectionUtil.findRedisClusterClient(beanLocator, serverName);
        if (clusterConn.isPresent()) {
            return (AbstractRedisClient)clusterConn.get();
        }
        Optional<RedisClient> conn = RedisConnectionUtil.findRedisClient(beanLocator, serverName);
        if (conn.isPresent()) {
            return (AbstractRedisClient)conn.get();
        }
        throw new ConfigurationException(errorMessage);
    }

    public static StatefulConnection findRedisConnection(BeanLocator beanLocator, Optional<String> serverName, String errorMessage) {
        Optional<StatefulRedisClusterConnection> clusterConn = RedisConnectionUtil.findStatefulRedisClusterConnection(beanLocator, serverName);
        if (clusterConn.isPresent()) {
            return (StatefulConnection)clusterConn.get();
        }
        Optional<StatefulRedisConnection> conn = RedisConnectionUtil.findStatefulRedisConnection(beanLocator, serverName);
        if (conn.isPresent()) {
            return (StatefulConnection)conn.get();
        }
        throw new ConfigurationException(errorMessage);
    }

    private static Optional<StatefulRedisClusterConnection> findStatefulRedisClusterConnection(BeanLocator beanLocator, Optional<String> serverName) {
        Optional<StatefulRedisClusterConnection> namedConn = serverName.flatMap(name -> beanLocator.findBean(StatefulRedisClusterConnection.class, Qualifiers.byName((String)name)));
        if (namedConn.isPresent()) {
            return namedConn;
        }
        return beanLocator.findBean(StatefulRedisClusterConnection.class);
    }

    private static Optional<StatefulRedisConnection> findStatefulRedisConnection(BeanLocator beanLocator, Optional<String> serverName) {
        Optional<StatefulRedisConnection> namedConn = serverName.flatMap(name -> beanLocator.findBean(StatefulRedisConnection.class, Qualifiers.byName((String)name)));
        if (namedConn.isPresent()) {
            return namedConn;
        }
        return beanLocator.findBean(StatefulRedisConnection.class);
    }

    public static StatefulConnection<byte[], byte[]> openBytesRedisConnection(BeanLocator beanLocator, Optional<String> serverName, String errorMessage) {
        Optional<RedisClusterClient> redisClusterClient = RedisConnectionUtil.findRedisClusterClient(beanLocator, serverName);
        if (redisClusterClient.isPresent()) {
            return redisClusterClient.get().connect((RedisCodec)ByteArrayCodec.INSTANCE);
        }
        Optional<RedisClient> redisClient = RedisConnectionUtil.findRedisClient(beanLocator, serverName);
        if (redisClient.isPresent()) {
            return redisClient.get().connect((RedisCodec)ByteArrayCodec.INSTANCE);
        }
        throw new ConfigurationException(errorMessage);
    }

    private static Optional<RedisClusterClient> findRedisClusterClient(BeanLocator beanLocator, Optional<String> serverName) {
        Optional<RedisClusterClient> namedClient = serverName.flatMap(name -> beanLocator.findBean(RedisClusterClient.class, Qualifiers.byName((String)name)));
        if (namedClient.isPresent()) {
            return namedClient;
        }
        return beanLocator.findBean(RedisClusterClient.class);
    }

    private static Optional<RedisClient> findRedisClient(BeanLocator beanLocator, Optional<String> serverName) {
        Optional<RedisClient> namedClient = serverName.flatMap(name -> beanLocator.findBean(RedisClient.class, Qualifiers.byName((String)name)));
        if (namedClient.isPresent()) {
            return namedClient;
        }
        return beanLocator.findBean(RedisClient.class);
    }
}

