/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.lettuce.cache;

import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.async.RedisKeyAsyncCommands;
import io.lettuce.core.api.async.RedisStringAsyncCommands;
import io.lettuce.core.api.sync.RedisKeyCommands;
import io.lettuce.core.api.sync.RedisStringCommands;
import io.micronaut.cache.AsyncCache;
import io.micronaut.cache.SyncCache;
import io.micronaut.configuration.lettuce.RedisConnectionUtil;
import io.micronaut.configuration.lettuce.cache.AbstractRedisCache;
import io.micronaut.configuration.lettuce.cache.DefaultRedisCacheConfiguration;
import io.micronaut.configuration.lettuce.cache.RedisCacheConfiguration;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import jakarta.annotation.PreDestroy;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;

@EachBean(value=RedisCacheConfiguration.class)
@Requires(classes={SyncCache.class}, property="redis.pool.enabled", defaultValue="false", notEquals="true")
public class RedisCache
extends AbstractRedisCache<StatefulConnection<byte[], byte[]>> {
    private final RedisAsyncCache asyncCache;
    private final StatefulConnection<byte[], byte[]> connection;
    private final RedisKeyCommands<byte[], byte[]> redisKeyCommands;
    private final RedisStringCommands<byte[], byte[]> redisStringCommands;
    private final RedisKeyAsyncCommands<byte[], byte[]> redisKeyAsyncCommands;
    private final RedisStringAsyncCommands<byte[], byte[]> redisStringAsyncCommands;

    public RedisCache(DefaultRedisCacheConfiguration defaultRedisCacheConfiguration, RedisCacheConfiguration redisCacheConfiguration, ConversionService conversionService, BeanLocator beanLocator) {
        super(defaultRedisCacheConfiguration, redisCacheConfiguration, conversionService, beanLocator);
        Optional<String> server = Optional.ofNullable(redisCacheConfiguration.getServer().orElse(defaultRedisCacheConfiguration.getServer().orElse(null)));
        this.connection = RedisConnectionUtil.openBytesRedisConnection(beanLocator, server, "No Redis server configured to allow caching");
        this.asyncCache = new RedisAsyncCache();
        this.redisKeyCommands = this.getRedisKeyCommands(this.connection);
        this.redisStringCommands = this.getRedisStringCommands(this.connection);
        this.redisKeyAsyncCommands = this.getRedisKeyAsyncCommands(this.connection);
        this.redisStringAsyncCommands = this.getRedisStringAsyncCommands(this.connection);
    }

    public String getName() {
        return this.redisCacheConfiguration.getCacheName();
    }

    public StatefulConnection<byte[], byte[]> getNativeCache() {
        return this.connection;
    }

    public <T> T get(Object key, Argument<T> requiredType, Supplier<T> supplier) {
        byte[] serializedKey = this.serializeKey(key);
        return this.get(serializedKey, requiredType, supplier, this.redisStringCommands);
    }

    public void invalidate(Object key) {
        byte[] serializedKey = this.serializeKey(key);
        this.redisKeyCommands.del((Object[])new byte[][]{serializedKey});
    }

    public void invalidateAll() {
        List keys = this.redisKeyCommands.keys((Object)this.getKeysPattern().getBytes(this.redisCacheConfiguration.getCharset()));
        if (!keys.isEmpty()) {
            this.redisKeyCommands.del((Object[])((byte[][])keys.toArray((T[])new byte[keys.size()][])));
        }
    }

    public AsyncCache<StatefulConnection<byte[], byte[]>> async() {
        return this.asyncCache;
    }

    @Override
    protected <T> Optional<T> getValue(Argument<T> requiredType, byte[] serializedKey) {
        byte[] data = (byte[])this.redisStringCommands.get((Object)serializedKey);
        if (this.expireAfterAccess != null) {
            this.redisKeyCommands.pexpire((Object)serializedKey, this.expireAfterAccess.longValue());
        }
        if (data != null) {
            return this.valueSerializer.deserialize(data, requiredType);
        }
        return Optional.empty();
    }

    @Override
    protected <T> void putValue(byte[] serializedKey, T value) {
        Optional serialized = this.valueSerializer.serialize(value);
        this.putValue(serializedKey, serialized, this.expireAfterWritePolicy, this.redisStringCommands, this.redisKeyCommands, value);
    }

    @Override
    @NonNull
    public <T> Optional<T> get(Object key, Argument<T> requiredType) {
        return super.get(key, requiredType);
    }

    @Override
    public void put(Object key, Object value) {
        super.put(key, value);
    }

    @Override
    @NonNull
    public <T> Optional<T> putIfAbsent(Object key, T value) {
        return super.putIfAbsent(key, value);
    }

    @Override
    protected String getKeysPattern() {
        return super.getKeysPattern();
    }

    @Override
    protected byte[] serializeKey(Object key) {
        return super.serializeKey(key);
    }

    @Override
    @PreDestroy
    public void close() {
        this.connection.close();
    }

    protected class RedisAsyncCache
    implements AsyncCache<StatefulConnection<byte[], byte[]>> {
        protected RedisAsyncCache() {
        }

        public <T> CompletableFuture<Optional<T>> get(Object key, Argument<T> requiredType) {
            byte[] serializedKey = RedisCache.this.serializeKey(key);
            return RedisCache.this.redisStringAsyncCommands.get((Object)serializedKey).thenCompose(data -> {
                if (data != null) {
                    return this.getWithExpire(requiredType, serializedKey, (byte[])data);
                }
                return CompletableFuture.completedFuture(Optional.empty());
            }).toCompletableFuture();
        }

        public <T> CompletableFuture<T> get(Object key, Argument<T> requiredType, Supplier<T> supplier) {
            byte[] serializedKey = RedisCache.this.serializeKey(key);
            return RedisCache.this.redisStringAsyncCommands.get((Object)serializedKey).thenCompose(data -> {
                if (data != null) {
                    Optional deserialized = RedisCache.this.valueSerializer.deserialize(data, requiredType);
                    boolean hasValue = deserialized.isPresent();
                    if (RedisCache.this.expireAfterAccess != null && hasValue) {
                        return RedisCache.this.redisKeyAsyncCommands.expire((Object)serializedKey, RedisCache.this.expireAfterAccess.longValue()).thenApply(ignore -> deserialized.get());
                    }
                    if (hasValue) {
                        return CompletableFuture.completedFuture(deserialized.get());
                    }
                }
                return this.putFromSupplier(serializedKey, supplier);
            }).toCompletableFuture();
        }

        public <T> CompletableFuture<Optional<T>> putIfAbsent(Object key, T value) {
            byte[] serializedKey = RedisCache.this.serializeKey(key);
            return RedisCache.this.redisStringAsyncCommands.get((Object)serializedKey).thenCompose(data -> {
                if (data != null) {
                    return this.getWithExpire((Argument)Argument.of(value.getClass()), serializedKey, (byte[])data);
                }
                Optional serialized = RedisCache.this.valueSerializer.serialize(value);
                if (serialized.isPresent()) {
                    return this.putWithExpire(serializedKey, (byte[])serialized.get(), value).thenApply(ignore -> Optional.of(value));
                }
                return CompletableFuture.completedFuture(Optional.empty());
            }).toCompletableFuture();
        }

        public CompletableFuture<Boolean> put(Object key, Object value) {
            byte[] serializedKey = RedisCache.this.serializeKey(key);
            Optional serialized = RedisCache.this.valueSerializer.serialize(value);
            if (serialized.isPresent()) {
                return this.putWithExpire(serializedKey, (byte[])serialized.get(), value).toCompletableFuture();
            }
            return this.deleteByKeys(new byte[][]{serializedKey});
        }

        public CompletableFuture<Boolean> invalidate(Object key) {
            return this.deleteByKeys(new byte[][]{RedisCache.this.serializeKey(key)});
        }

        public CompletableFuture<Boolean> invalidateAll() {
            return RedisCache.this.redisKeyAsyncCommands.keys((Object)RedisCache.this.getKeysPattern().getBytes(RedisCache.this.redisCacheConfiguration.getCharset())).thenCompose(keys -> this.deleteByKeys((byte[][])keys.toArray((T[])new byte[keys.size()][]))).toCompletableFuture();
        }

        private CompletableFuture<Boolean> deleteByKeys(byte[] ... serializedKey) {
            return RedisCache.this.redisKeyAsyncCommands.del((Object[])serializedKey).thenApply(keysDeleted -> keysDeleted > 0L).toCompletableFuture();
        }

        public String getName() {
            return RedisCache.this.getName();
        }

        public StatefulConnection<byte[], byte[]> getNativeCache() {
            return RedisCache.this.getNativeCache();
        }

        private <T> CompletionStage<Optional<T>> getWithExpire(Argument<T> requiredType, byte[] serializedKey, byte[] data) {
            Optional deserialized = RedisCache.this.valueSerializer.deserialize(data, requiredType);
            if (RedisCache.this.expireAfterAccess != null && deserialized.isPresent()) {
                return RedisCache.this.redisKeyAsyncCommands.expire((Object)serializedKey, RedisCache.this.expireAfterAccess.longValue()).thenApply(ignore -> deserialized);
            }
            return CompletableFuture.completedFuture(deserialized);
        }

        private <T> CompletionStage<T> putFromSupplier(byte[] serializedKey, Supplier<T> supplier) {
            return this.supply(supplier).thenCompose(value -> {
                Optional serialized = RedisCache.this.valueSerializer.serialize(value);
                if (serialized.isPresent()) {
                    return this.putWithExpire(serializedKey, (byte[])serialized.get(), value).thenApply(ignore -> value);
                }
                return CompletableFuture.completedFuture(null);
            });
        }

        private <T> CompletionStage<T> supply(Supplier<T> supplier) {
            CompletableFuture<T> completableFuture = new CompletableFuture<T>();
            try {
                completableFuture.complete(supplier.get());
            }
            catch (Throwable e) {
                completableFuture.completeExceptionally(e);
            }
            return completableFuture;
        }

        private CompletionStage<Boolean> putWithExpire(byte[] serializedKey, byte[] serialized, Object value) {
            if (RedisCache.this.expireAfterWritePolicy != null) {
                return RedisCache.this.redisStringAsyncCommands.psetex((Object)serializedKey, RedisCache.this.expireAfterWritePolicy.getExpirationAfterWrite(value), (Object)serialized).thenApply(this.isOK());
            }
            return RedisCache.this.redisStringAsyncCommands.set((Object)serializedKey, (Object)serialized).thenApply(this.isOK());
        }

        private Function<String, Boolean> isOK() {
            return "OK"::equals;
        }
    }
}

