/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.lettuce.cache;

import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.async.RedisKeyAsyncCommands;
import io.lettuce.core.api.async.RedisStringAsyncCommands;
import io.lettuce.core.api.sync.RedisKeyCommands;
import io.lettuce.core.api.sync.RedisStringCommands;
import io.lettuce.core.support.AsyncPool;
import io.micronaut.cache.AsyncCache;
import io.micronaut.cache.SyncCache;
import io.micronaut.configuration.lettuce.cache.AbstractRedisCache;
import io.micronaut.configuration.lettuce.cache.DefaultRedisCacheConfiguration;
import io.micronaut.configuration.lettuce.cache.RedisCacheConfiguration;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import jakarta.annotation.PreDestroy;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EachBean(value=RedisCacheConfiguration.class)
@Requires(classes={SyncCache.class}, property="redis.pool.enabled", defaultValue="false", notEquals="false")
public class RedisConnectionPoolCache
extends AbstractRedisCache<AsyncPool<StatefulConnection<byte[], byte[]>>> {
    private static final Logger LOG = LoggerFactory.getLogger(RedisConnectionPoolCache.class);
    private final RedisAsyncCache asyncCache = new RedisAsyncCache();
    private final AsyncPool<StatefulConnection<byte[], byte[]>> asyncPool;

    public RedisConnectionPoolCache(DefaultRedisCacheConfiguration defaultRedisCacheConfiguration, RedisCacheConfiguration redisCacheConfiguration, ConversionService conversionService, BeanLocator beanLocator, AsyncPool<StatefulConnection<byte[], byte[]>> asyncPool) {
        super(defaultRedisCacheConfiguration, redisCacheConfiguration, conversionService, beanLocator);
        this.asyncPool = asyncPool;
    }

    public String getName() {
        return this.redisCacheConfiguration.getCacheName();
    }

    public AsyncPool<StatefulConnection<byte[], byte[]>> getNativeCache() {
        return this.asyncPool;
    }

    public <T> T get(@NonNull Object key, @NonNull Argument<T> requiredType, @NonNull Supplier<T> supplier) {
        byte[] serializedKey = this.serializeKey(key);
        return ((CompletableFuture)this.asyncPool.acquire().thenCompose(connection -> {
            try {
                RedisStringCommands<byte[], byte[]> commands = this.getRedisStringCommands((StatefulConnection<byte[], byte[]>)connection);
                CompletableFuture completableFuture = CompletableFuture.completedFuture(this.get(serializedKey, requiredType, supplier, commands));
                return completableFuture;
            }
            finally {
                this.asyncPool.release(connection);
            }
        })).join();
    }

    public void invalidate(Object key) {
        byte[] serializedKey = this.serializeKey(key);
        ((CompletableFuture)this.asyncPool.acquire().thenAccept(connection -> {
            try {
                RedisKeyCommands<byte[], byte[]> commands = this.getRedisKeyCommands((StatefulConnection<byte[], byte[]>)connection);
                this.invalidate(Collections.singletonList(serializedKey), commands);
            }
            finally {
                this.asyncPool.release(connection);
            }
        })).join();
    }

    private void invalidate(List<byte[]> key, RedisKeyCommands<byte[], byte[]> commands) {
        commands.del((Object[])((byte[][])key.toArray((T[])new byte[0][])));
    }

    public void invalidateAll() {
        ((CompletableFuture)this.asyncPool.acquire().thenAccept(connection -> {
            try {
                RedisKeyCommands<byte[], byte[]> commands = this.getRedisKeyCommands((StatefulConnection<byte[], byte[]>)connection);
                List<byte[]> keys = this.allKeys(commands, this.getKeysPattern().getBytes(this.redisCacheConfiguration.getCharset()));
                if (!keys.isEmpty()) {
                    this.invalidate(keys, commands);
                }
            }
            finally {
                this.asyncPool.release(connection);
            }
        })).join();
    }

    private List<byte[]> allKeys(RedisKeyCommands<byte[], byte[]> commands, byte[] pattern) {
        return commands.keys((Object)pattern);
    }

    public AsyncCache<AsyncPool<StatefulConnection<byte[], byte[]>>> async() {
        return this.asyncCache;
    }

    @Override
    protected <T> Optional<T> getValue(Argument<T> requiredType, byte[] serializedKey) {
        return (Optional)((CompletableFuture)this.asyncPool.acquire().thenCompose(connection -> {
            try {
                RedisStringCommands<byte[], byte[]> stringCommands = this.getRedisStringCommands((StatefulConnection<byte[], byte[]>)connection);
                RedisKeyCommands<byte[], byte[]> keyCommands = this.getRedisKeyCommands((StatefulConnection<byte[], byte[]>)connection);
                CompletableFuture completableFuture = CompletableFuture.completedFuture(this.getValue(requiredType, serializedKey, stringCommands, keyCommands));
                return completableFuture;
            }
            finally {
                this.asyncPool.release(connection);
            }
        })).join();
    }

    private <T> Optional<T> getValue(Argument<T> requiredType, byte[] serializedKey, RedisStringCommands<byte[], byte[]> stringCommands, RedisKeyCommands<byte[], byte[]> keyCommands) {
        byte[] data = (byte[])stringCommands.get((Object)serializedKey);
        if (this.expireAfterAccess != null) {
            keyCommands.pexpire((Object)serializedKey, this.expireAfterAccess.longValue());
        }
        if (data != null) {
            return this.valueSerializer.deserialize(data, requiredType);
        }
        return Optional.empty();
    }

    @Override
    protected <T> void putValue(byte[] serializedKey, T value) {
        Optional serialized = this.valueSerializer.serialize(value);
        ((CompletableFuture)this.asyncPool.acquire().thenAccept(connection -> {
            try {
                RedisStringCommands<byte[], byte[]> stringCommands = this.getRedisStringCommands((StatefulConnection<byte[], byte[]>)connection);
                RedisKeyCommands<byte[], byte[]> keyCommands = this.getRedisKeyCommands((StatefulConnection<byte[], byte[]>)connection);
                this.putValue(serializedKey, serialized, stringCommands, keyCommands);
            }
            finally {
                this.asyncPool.release(connection);
            }
        })).join();
    }

    private void putValue(byte[] serializedKey, Optional<byte[]> value, RedisStringCommands<byte[], byte[]> stringCommands, RedisKeyCommands<byte[], byte[]> keyCommands) {
        this.putValue(serializedKey, value, this.expireAfterWritePolicy, stringCommands, keyCommands, value);
    }

    @Override
    @PreDestroy
    public void close() {
        this.asyncPool.close();
    }

    protected class RedisAsyncCache
    implements AsyncCache<AsyncPool<StatefulConnection<byte[], byte[]>>> {
        protected RedisAsyncCache() {
        }

        public <T> CompletableFuture<Optional<T>> get(Object key, Argument<T> requiredType) {
            byte[] serializedKey = RedisConnectionPoolCache.this.serializeKey(key);
            return RedisConnectionPoolCache.this.asyncPool.acquire().thenCompose(connection -> {
                RedisStringAsyncCommands<byte[], byte[]> commands = RedisConnectionPoolCache.this.getRedisStringAsyncCommands((StatefulConnection<byte[], byte[]>)connection);
                return commands.get((Object)serializedKey).thenCompose(data -> {
                    if (data != null) {
                        return this.getWithExpire(requiredType, serializedKey, (byte[])data);
                    }
                    return CompletableFuture.completedFuture(Optional.empty());
                }).whenComplete((data, ex) -> {
                    RedisConnectionPoolCache.this.asyncPool.release(connection);
                    if (ex != null) {
                        LOG.error(ex.getMessage(), ex);
                    }
                });
            });
        }

        public <T> CompletableFuture<T> get(Object key, Argument<T> requiredType, Supplier<T> supplier) {
            byte[] serializedKey = RedisConnectionPoolCache.this.serializeKey(key);
            return RedisConnectionPoolCache.this.asyncPool.acquire().thenCompose(connection -> {
                RedisStringAsyncCommands<byte[], byte[]> stringCommands = RedisConnectionPoolCache.this.getRedisStringAsyncCommands((StatefulConnection<byte[], byte[]>)connection);
                RedisKeyAsyncCommands<byte[], byte[]> keyCommands = RedisConnectionPoolCache.this.getRedisKeyAsyncCommands((StatefulConnection<byte[], byte[]>)connection);
                return stringCommands.get((Object)serializedKey).thenCompose(arg_0 -> this.lambda$get$4(requiredType, keyCommands, serializedKey, (Supplier)supplier, arg_0)).whenComplete((data, ex) -> {
                    RedisConnectionPoolCache.this.asyncPool.release(connection);
                    if (ex != null) {
                        LOG.error(ex.getMessage(), ex);
                    }
                });
            });
        }

        public <T> CompletableFuture<Optional<T>> putIfAbsent(Object key, T value) {
            byte[] serializedKey = RedisConnectionPoolCache.this.serializeKey(key);
            return RedisConnectionPoolCache.this.asyncPool.acquire().thenCompose(connection -> {
                RedisStringAsyncCommands<byte[], byte[]> stringCommands = RedisConnectionPoolCache.this.getRedisStringAsyncCommands((StatefulConnection<byte[], byte[]>)connection);
                return stringCommands.get((Object)serializedKey).thenCompose(data -> {
                    if (data != null) {
                        return this.getWithExpire((Argument)Argument.of(value.getClass()), serializedKey, (byte[])data);
                    }
                    Optional serialized = RedisConnectionPoolCache.this.valueSerializer.serialize(value);
                    if (serialized.isPresent()) {
                        return this.putWithExpire(serializedKey, (byte[])serialized.get(), value).thenApply(ignore -> Optional.of(value));
                    }
                    return CompletableFuture.completedFuture(Optional.empty());
                }).whenComplete((data, ex) -> {
                    RedisConnectionPoolCache.this.asyncPool.release(connection);
                    if (ex != null) {
                        LOG.error(ex.getMessage(), ex);
                    }
                });
            });
        }

        public CompletableFuture<Boolean> put(Object key, Object value) {
            byte[] serializedKey = RedisConnectionPoolCache.this.serializeKey(key);
            Optional serialized = RedisConnectionPoolCache.this.valueSerializer.serialize(value);
            if (serialized.isPresent()) {
                return this.putWithExpire(serializedKey, (byte[])serialized.get(), value).toCompletableFuture();
            }
            return this.deleteByKeys(new byte[][]{serializedKey});
        }

        public CompletableFuture<Boolean> invalidate(Object key) {
            return this.deleteByKeys(new byte[][]{RedisConnectionPoolCache.this.serializeKey(key)});
        }

        public CompletableFuture<Boolean> invalidateAll() {
            return RedisConnectionPoolCache.this.asyncPool.acquire().thenCompose(connection -> {
                RedisKeyAsyncCommands<byte[], byte[]> commands = RedisConnectionPoolCache.this.getRedisKeyAsyncCommands((StatefulConnection<byte[], byte[]>)connection);
                return commands.keys((Object)RedisConnectionPoolCache.this.getKeysPattern().getBytes(RedisConnectionPoolCache.this.redisCacheConfiguration.getCharset())).thenCompose(keys -> this.deleteByKeys((byte[][])keys.toArray((T[])new byte[keys.size()][]))).whenComplete((data, ex) -> {
                    RedisConnectionPoolCache.this.asyncPool.release(connection);
                    if (ex != null) {
                        LOG.error(ex.getMessage(), ex);
                    }
                });
            });
        }

        private CompletableFuture<Boolean> deleteByKeys(byte[] ... serializedKey) {
            return RedisConnectionPoolCache.this.asyncPool.acquire().thenCompose(connection -> {
                if (serializedKey.length > 0) {
                    RedisKeyAsyncCommands<byte[], byte[]> commands = RedisConnectionPoolCache.this.getRedisKeyAsyncCommands((StatefulConnection<byte[], byte[]>)connection);
                    return commands.del((Object[])serializedKey).thenApply(keysDeleted -> keysDeleted > 0L).whenComplete((data, ex) -> {
                        RedisConnectionPoolCache.this.asyncPool.release(connection);
                        if (ex != null) {
                            LOG.error(ex.getMessage(), ex);
                        }
                    });
                }
                return CompletableFuture.completedFuture(true);
            });
        }

        public String getName() {
            return RedisConnectionPoolCache.this.getName();
        }

        public AsyncPool<StatefulConnection<byte[], byte[]>> getNativeCache() {
            return RedisConnectionPoolCache.this.asyncPool;
        }

        private <T> CompletionStage<Optional<T>> getWithExpire(Argument<T> requiredType, byte[] serializedKey, byte[] data) {
            Optional deserialized = RedisConnectionPoolCache.this.valueSerializer.deserialize(data, requiredType);
            if (RedisConnectionPoolCache.this.expireAfterAccess != null && deserialized.isPresent()) {
                return RedisConnectionPoolCache.this.asyncPool.acquire().thenCompose(connection -> {
                    RedisKeyAsyncCommands<byte[], byte[]> commands = RedisConnectionPoolCache.this.getRedisKeyAsyncCommands((StatefulConnection<byte[], byte[]>)connection);
                    return commands.expire((Object)serializedKey, RedisConnectionPoolCache.this.expireAfterAccess.longValue()).thenApply(ignore -> deserialized).whenComplete((result, ex) -> {
                        RedisConnectionPoolCache.this.asyncPool.release(connection);
                        if (ex != null) {
                            LOG.error(ex.getMessage(), ex);
                        }
                    });
                });
            }
            return CompletableFuture.completedFuture(deserialized);
        }

        private <T> CompletionStage<T> putFromSupplier(byte[] serializedKey, Supplier<T> supplier) {
            return this.supply(supplier).thenCompose(value -> {
                Optional serialized = RedisConnectionPoolCache.this.valueSerializer.serialize(value);
                if (serialized.isPresent()) {
                    return this.putWithExpire(serializedKey, (byte[])serialized.get(), value).thenApply(ignore -> value);
                }
                return CompletableFuture.completedFuture(null);
            });
        }

        private <T> CompletionStage<T> supply(Supplier<T> supplier) {
            CompletableFuture<T> completableFuture = new CompletableFuture<T>();
            try {
                completableFuture.complete(supplier.get());
            }
            catch (Exception e) {
                completableFuture.completeExceptionally(e);
            }
            return completableFuture;
        }

        private CompletionStage<Boolean> putWithExpire(byte[] serializedKey, byte[] serialized, Object value) {
            return RedisConnectionPoolCache.this.asyncPool.acquire().thenCompose(connection -> {
                RedisStringAsyncCommands<byte[], byte[]> commands = RedisConnectionPoolCache.this.getRedisStringAsyncCommands((StatefulConnection<byte[], byte[]>)connection);
                if (RedisConnectionPoolCache.this.expireAfterWritePolicy != null) {
                    return commands.psetex((Object)serializedKey, RedisConnectionPoolCache.this.expireAfterWritePolicy.getExpirationAfterWrite(value), (Object)serialized).whenComplete((result, ex) -> {
                        RedisConnectionPoolCache.this.asyncPool.release(connection);
                        if (ex != null) {
                            LOG.error(ex.getMessage(), ex);
                        }
                    }).thenApply(this.isOK());
                }
                return commands.set((Object)serializedKey, (Object)serialized).whenComplete((result, ex) -> {
                    RedisConnectionPoolCache.this.asyncPool.release(connection);
                    if (ex != null) {
                        LOG.error(ex.getMessage(), ex);
                    }
                }).thenApply(this.isOK());
            });
        }

        private Function<String, Boolean> isOK() {
            return "OK"::equals;
        }

        private /* synthetic */ CompletionStage lambda$get$4(Argument requiredType, RedisKeyAsyncCommands keyCommands, byte[] serializedKey, Supplier supplier, byte[] data) {
            if (data != null) {
                Optional deserialized = RedisConnectionPoolCache.this.valueSerializer.deserialize(data, requiredType);
                boolean hasValue = deserialized.isPresent();
                if (RedisConnectionPoolCache.this.expireAfterAccess != null && hasValue) {
                    return keyCommands.expire((Object)serializedKey, RedisConnectionPoolCache.this.expireAfterAccess.longValue()).thenApply(ignore -> deserialized.get());
                }
                if (hasValue) {
                    return CompletableFuture.completedFuture(deserialized.get());
                }
            }
            return this.putFromSupplier(serializedKey, supplier);
        }
    }
}

