/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.lettuce;

import io.lettuce.core.ReadFrom;
import io.lettuce.core.RedisURI;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.Named;
import io.micronaut.core.util.Toggleable;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class AbstractRedisConfiguration
extends RedisURI
implements Named,
Toggleable {
    private RedisURI uri;
    private List<RedisURI> uris = Collections.emptyList();
    private List<RedisURI> replicaUris = Collections.emptyList();
    private Integer ioThreadPoolSize;
    private Integer computationThreadPoolSize;
    private String name;
    private ReadFrom readFrom;

    protected AbstractRedisConfiguration() {
        this.setName("application");
        this.setPort(6379);
        this.setHost("localhost");
    }

    public Optional<RedisURI> getUri() {
        if (this.uri != null) {
            this.uri.setClientName(this.getClientName());
        }
        return Optional.ofNullable(this.uri);
    }

    public void setUri(URI uri) {
        this.uri = RedisURI.create((URI)uri);
    }

    public List<RedisURI> getUris() {
        return this.uris;
    }

    public void setUris(URI ... uris) {
        this.uris = Arrays.stream(uris).map(RedisURI::create).collect(Collectors.toList());
    }

    public List<RedisURI> getReplicaUris() {
        return this.replicaUris;
    }

    public void setReplicaUris(URI ... uris) {
        this.replicaUris = Arrays.stream(uris).map(RedisURI::create).collect(Collectors.toList());
    }

    public Integer getIoThreadPoolSize() {
        return this.ioThreadPoolSize;
    }

    public void setIoThreadPoolSize(Integer ioThreadPoolSize) {
        this.ioThreadPoolSize = ioThreadPoolSize;
    }

    public Integer getComputationThreadPoolSize() {
        return this.computationThreadPoolSize;
    }

    public void setComputationThreadPoolSize(Integer computationThreadPoolSize) {
        this.computationThreadPoolSize = computationThreadPoolSize;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Optional<ReadFrom> getReadFrom() {
        return Optional.ofNullable(this.readFrom);
    }

    public void setReadFrom(@NonNull String readFrom) {
        this.readFrom = ReadFrom.valueOf((String)readFrom);
    }
}

