/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.lettuce;

import io.lettuce.core.RedisURI;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.resource.ClientResources;
import io.micronaut.configuration.lettuce.AbstractRedisConfiguration;
import io.micronaut.configuration.lettuce.ClientResourcesMutator;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@Requires(property="redis.uris")
@Singleton
@Factory
public class DefaultRedisClusterClientFactory {
    @Deprecated(since="6.1.0", forRemoval=true)
    public RedisClusterClient redisClient(AbstractRedisConfiguration config, @Nullable ClientResources defaultClientResources) {
        return this.redisClient(config, defaultClientResources, Collections.emptyList());
    }

    @Bean(preDestroy="shutdown")
    @Singleton
    @Primary
    public RedisClusterClient redisClient(@Primary AbstractRedisConfiguration config, @Primary @Nullable ClientResources defaultClientResources, @Nullable List<ClientResourcesMutator> mutators) {
        List<RedisURI> uris = config.getUris();
        if (CollectionUtils.isEmpty(uris)) {
            throw new ConfigurationException("Redis URIs must be specified");
        }
        ClientResources.Builder builder = Optional.ofNullable(defaultClientResources).map(ClientResources::mutate).orElseGet(ClientResources::builder);
        if (mutators != null) {
            mutators.forEach(m -> m.mutate(builder, config));
        }
        return RedisClusterClient.create((ClientResources)builder.build(), uris);
    }

    @Bean(preDestroy="close")
    @Singleton
    @Primary
    public StatefulRedisClusterConnection<String, String> redisConnection(@Primary RedisClusterClient redisClient, @Primary AbstractRedisConfiguration config) {
        StatefulRedisClusterConnection connection = redisClient.connect();
        if (config.getReadFrom().isPresent()) {
            connection.setReadFrom(config.getReadFrom().get());
        }
        return connection;
    }

    @Deprecated(since="6.5.0", forRemoval=true)
    public StatefulRedisClusterConnection<String, String> redisConnection(@Primary RedisClusterClient redisClient) {
        return redisClient.connect();
    }

    @Bean(preDestroy="close")
    @Singleton
    public StatefulRedisPubSubConnection<String, String> redisPubSubConnection(@Primary RedisClusterClient redisClient) {
        return redisClient.connectPubSub();
    }
}

