/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.lettuce;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.masterreplica.MasterReplica;
import io.lettuce.core.masterreplica.StatefulRedisMasterReplicaConnection;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.resource.ClientResources;
import io.micronaut.configuration.lettuce.AbstractRedisClientFactory;
import io.micronaut.configuration.lettuce.ClientResourcesMutator;
import io.micronaut.configuration.lettuce.NamedRedisServersConfiguration;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.ArrayList;
import java.util.List;

@Factory
public class NamedRedisClientFactory<K, V>
extends AbstractRedisClientFactory<K, V> {
    private final BeanLocator beanLocator;
    private final ClientResources defaultClientResources;

    public NamedRedisClientFactory(BeanLocator beanLocator, @Primary @Nullable ClientResources defaultClientResources, @Primary RedisCodec<K, V> codec) {
        super(codec);
        this.beanLocator = beanLocator;
        this.defaultClientResources = defaultClientResources;
    }

    @Bean(preDestroy="shutdown")
    @EachBean(value=NamedRedisServersConfiguration.class)
    public RedisClient redisClient(NamedRedisServersConfiguration config, @Nullable List<ClientResourcesMutator> mutators) {
        return super.redisClient(config, this.getClientResources(config), mutators);
    }

    @Bean(preDestroy="close")
    @EachBean(value=NamedRedisServersConfiguration.class)
    public StatefulRedisConnection<K, V> redisConnection(NamedRedisServersConfiguration config) {
        StatefulRedisMasterReplicaConnection connection;
        RedisCodec namedCodec = this.beanLocator.findBean(RedisCodec.class, Qualifiers.byName((String)config.getName())).orElse(this.defaultCodec);
        if (config.getUri().isPresent() && !config.getReplicaUris().isEmpty()) {
            ArrayList<RedisURI> uris = new ArrayList<RedisURI>(config.getReplicaUris());
            uris.add(config.getUri().get());
            connection = MasterReplica.connect((RedisClient)this.getRedisClient(config), (RedisCodec)namedCodec, uris);
            if (config.getReadFrom().isPresent()) {
                connection.setReadFrom(config.getReadFrom().get());
            }
        } else {
            connection = super.redisConnection(this.getRedisClient(config), namedCodec);
            if (connection instanceof StatefulRedisClusterConnection) {
                StatefulRedisClusterConnection conn = (StatefulRedisClusterConnection)connection;
                if (config.getReadFrom().isPresent()) {
                    conn.setReadFrom(config.getReadFrom().get());
                }
            }
        }
        return connection;
    }

    @Bean(preDestroy="close")
    @EachBean(value=NamedRedisServersConfiguration.class)
    public StatefulRedisPubSubConnection<K, V> redisPubSubConnection(NamedRedisServersConfiguration config) {
        RedisCodec namedCodec = this.beanLocator.findBean(RedisCodec.class, Qualifiers.byName((String)config.getName())).orElse(this.defaultCodec);
        return super.redisPubSubConnection(this.getRedisClient(config), namedCodec);
    }

    @Nullable
    private ClientResources getClientResources(NamedRedisServersConfiguration config) {
        return this.beanLocator.findBean(ClientResources.class, Qualifiers.byName((String)config.getName())).orElse(this.defaultClientResources);
    }

    private RedisClient getRedisClient(NamedRedisServersConfiguration config) {
        return (RedisClient)this.beanLocator.getBean(RedisClient.class, Qualifiers.byName((String)config.getName()));
    }
}

