/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.lettuce;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.masterreplica.MasterReplica;
import io.lettuce.core.masterreplica.StatefulRedisMasterReplicaConnection;
import io.micronaut.configuration.lettuce.DefaultRedisConfiguration;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.ArrayList;
import java.util.Optional;

@Internal
public class RedisConnectionUtil {
    @NonNull
    public static AbstractRedisClient findClient(BeanLocator beanLocator, Optional<String> serverName, String errorMessage) {
        Optional<RedisClusterClient> clusterConn = RedisConnectionUtil.findRedisClusterClient(beanLocator, serverName);
        if (clusterConn.isPresent()) {
            return (AbstractRedisClient)clusterConn.get();
        }
        Optional<RedisClient> conn = RedisConnectionUtil.findRedisClient(beanLocator, serverName);
        if (conn.isPresent()) {
            return (AbstractRedisClient)conn.get();
        }
        throw new ConfigurationException(errorMessage);
    }

    public static StatefulConnection findRedisConnection(BeanLocator beanLocator, Optional<String> serverName, String errorMessage) {
        Optional<StatefulRedisClusterConnection> clusterConn = RedisConnectionUtil.findStatefulRedisClusterConnection(beanLocator, serverName);
        if (clusterConn.isPresent()) {
            return (StatefulConnection)clusterConn.get();
        }
        Optional<StatefulRedisConnection> conn = RedisConnectionUtil.findStatefulRedisConnection(beanLocator, serverName);
        if (conn.isPresent()) {
            return (StatefulConnection)conn.get();
        }
        throw new ConfigurationException(errorMessage);
    }

    private static Optional<StatefulRedisClusterConnection> findStatefulRedisClusterConnection(BeanLocator beanLocator, Optional<String> serverName) {
        Optional<StatefulRedisClusterConnection> namedConn = serverName.flatMap(name -> beanLocator.findBean(StatefulRedisClusterConnection.class, Qualifiers.byName((String)name)));
        if (namedConn.isPresent()) {
            return namedConn;
        }
        return beanLocator.findBean(StatefulRedisClusterConnection.class);
    }

    private static Optional<StatefulRedisConnection> findStatefulRedisConnection(BeanLocator beanLocator, Optional<String> serverName) {
        Optional<StatefulRedisConnection> namedConn = serverName.flatMap(name -> beanLocator.findBean(StatefulRedisConnection.class, Qualifiers.byName((String)name)));
        if (namedConn.isPresent()) {
            return namedConn;
        }
        return beanLocator.findBean(StatefulRedisConnection.class);
    }

    public static StatefulConnection<byte[], byte[]> openBytesRedisConnection(BeanLocator beanLocator, Optional<String> serverName, String errorMessage) {
        Optional config = beanLocator.findBean(DefaultRedisConfiguration.class);
        Optional<RedisClusterClient> redisClusterClient = RedisConnectionUtil.findRedisClusterClient(beanLocator, serverName);
        if (redisClusterClient.isPresent()) {
            StatefulRedisClusterConnection conn = redisClusterClient.get().connect((RedisCodec)ByteArrayCodec.INSTANCE);
            if (config.isPresent() && ((DefaultRedisConfiguration)((Object)config.get())).getReadFrom().isPresent()) {
                conn.setReadFrom(((DefaultRedisConfiguration)((Object)config.get())).getReadFrom().get());
            }
            return conn;
        }
        Optional<RedisClient> redisClient = RedisConnectionUtil.findRedisClient(beanLocator, serverName);
        if (redisClient.isPresent()) {
            if (config.isPresent() && ((DefaultRedisConfiguration)((Object)config.get())).getUri().isPresent() && !((DefaultRedisConfiguration)((Object)config.get())).getReplicaUris().isEmpty()) {
                ArrayList<RedisURI> uris = new ArrayList<RedisURI>(((DefaultRedisConfiguration)((Object)config.get())).getReplicaUris());
                uris.add(((DefaultRedisConfiguration)((Object)config.get())).getUri().get());
                StatefulRedisMasterReplicaConnection connection = MasterReplica.connect((RedisClient)redisClient.get(), (RedisCodec)ByteArrayCodec.INSTANCE, uris);
                if (((DefaultRedisConfiguration)((Object)config.get())).getReadFrom().isPresent()) {
                    connection.setReadFrom(((DefaultRedisConfiguration)((Object)config.get())).getReadFrom().get());
                }
                return connection;
            }
            return redisClient.get().connect((RedisCodec)ByteArrayCodec.INSTANCE);
        }
        throw new ConfigurationException(errorMessage);
    }

    private static Optional<RedisClusterClient> findRedisClusterClient(BeanLocator beanLocator, Optional<String> serverName) {
        Optional<RedisClusterClient> namedClient = serverName.flatMap(name -> beanLocator.findBean(RedisClusterClient.class, Qualifiers.byName((String)name)));
        if (namedClient.isPresent()) {
            return namedClient;
        }
        return beanLocator.findBean(RedisClusterClient.class);
    }

    private static Optional<RedisClient> findRedisClient(BeanLocator beanLocator, Optional<String> serverName) {
        Optional<RedisClient> namedClient = serverName.flatMap(name -> beanLocator.findBean(RedisClient.class, Qualifiers.byName((String)name)));
        if (namedClient.isPresent()) {
            return namedClient;
        }
        return beanLocator.findBean(RedisClient.class);
    }
}

