/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.lettuce.cache;

import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.api.async.RedisKeyAsyncCommands;
import io.lettuce.core.api.async.RedisStringAsyncCommands;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.api.sync.RedisKeyCommands;
import io.lettuce.core.api.sync.RedisStringCommands;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.micronaut.cache.SyncCache;
import io.micronaut.cache.serialize.DefaultStringKeySerializer;
import io.micronaut.configuration.lettuce.cache.AbstractRedisCacheConfiguration;
import io.micronaut.configuration.lettuce.cache.DefaultRedisCacheConfiguration;
import io.micronaut.configuration.lettuce.cache.RedisCacheConfiguration;
import io.micronaut.configuration.lettuce.cache.expiration.ConstantExpirationAfterWritePolicy;
import io.micronaut.configuration.lettuce.cache.expiration.ExpirationAfterWritePolicy;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.serialize.JdkSerializer;
import io.micronaut.core.serialize.ObjectSerializer;
import io.micronaut.core.type.Argument;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Supplier;

public abstract class AbstractRedisCache<C>
implements SyncCache<C>,
AutoCloseable {
    public static final String INVALID_REDIS_CONNECTION_MESSAGE = "Invalid Redis connection";
    protected final ObjectSerializer keySerializer;
    protected final ObjectSerializer valueSerializer;
    protected final RedisCacheConfiguration redisCacheConfiguration;
    protected final ExpirationAfterWritePolicy expireAfterWritePolicy;
    protected final Long expireAfterAccess;
    protected final Long invalidateScanCount;

    protected AbstractRedisCache(DefaultRedisCacheConfiguration defaultRedisCacheConfiguration, RedisCacheConfiguration redisCacheConfiguration, ConversionService conversionService, BeanLocator beanLocator) {
        if (redisCacheConfiguration == null) {
            throw new IllegalArgumentException("Redis cache configuration cannot be null");
        }
        this.redisCacheConfiguration = redisCacheConfiguration;
        this.expireAfterWritePolicy = this.configureExpirationAfterWritePolicy(redisCacheConfiguration, beanLocator);
        this.keySerializer = redisCacheConfiguration.getKeySerializer().flatMap(arg_0 -> ((BeanLocator)beanLocator).findOrInstantiateBean(arg_0)).orElse((ObjectSerializer)defaultRedisCacheConfiguration.getKeySerializer().flatMap(arg_0 -> ((BeanLocator)beanLocator).findOrInstantiateBean(arg_0)).orElse(this.newDefaultKeySerializer(redisCacheConfiguration, conversionService)));
        this.valueSerializer = redisCacheConfiguration.getValueSerializer().flatMap(arg_0 -> ((BeanLocator)beanLocator).findOrInstantiateBean(arg_0)).orElse((ObjectSerializer)defaultRedisCacheConfiguration.getValueSerializer().flatMap(arg_0 -> ((BeanLocator)beanLocator).findOrInstantiateBean(arg_0)).orElse(new JdkSerializer(conversionService)));
        this.expireAfterAccess = redisCacheConfiguration.getExpireAfterAccess().map(Duration::toMillis).orElse(defaultRedisCacheConfiguration.getExpireAfterAccess().map(Duration::toMillis).orElse(null));
        this.invalidateScanCount = redisCacheConfiguration.getInvalidateScanCount().orElse(100L);
    }

    public <T> Optional<T> get(Object key, Argument<T> requiredType) {
        byte[] serializedKey = this.serializeKey(key);
        return this.getValue(requiredType, serializedKey);
    }

    public void put(Object key, Object value) {
        byte[] serializedKey = this.serializeKey(key);
        this.putValue(serializedKey, value);
    }

    public <T> Optional<T> putIfAbsent(Object key, T value) {
        if (value == null) {
            return Optional.empty();
        }
        byte[] serializedKey = this.serializeKey(key);
        Optional<T> existing = this.getValue(Argument.of(value.getClass()), serializedKey);
        if (!existing.isPresent()) {
            this.putValue(serializedKey, value);
            return Optional.empty();
        }
        return existing;
    }

    protected <T> T get(byte[] key, Argument<T> requiredType, Supplier<T> supplier, RedisStringCommands<byte[], byte[]> commands) {
        Optional deserialized;
        byte[] data = (byte[])commands.get((Object)key);
        if (data != null && (deserialized = this.valueSerializer.deserialize(data, requiredType)).isPresent()) {
            return deserialized.get();
        }
        T value = supplier.get();
        this.putValue(key, value);
        return value;
    }

    protected RedisStringAsyncCommands<byte[], byte[]> getRedisStringAsyncCommands(StatefulConnection<byte[], byte[]> connection) {
        RedisAsyncCommands commands;
        if (connection instanceof StatefulRedisConnection) {
            commands = ((StatefulRedisConnection)connection).async();
        } else if (connection instanceof StatefulRedisClusterConnection) {
            commands = ((StatefulRedisClusterConnection)connection).async();
        } else {
            throw new ConfigurationException(INVALID_REDIS_CONNECTION_MESSAGE);
        }
        return commands;
    }

    protected RedisKeyAsyncCommands<byte[], byte[]> getRedisKeyAsyncCommands(StatefulConnection<byte[], byte[]> connection) {
        RedisAsyncCommands commands;
        if (connection instanceof StatefulRedisConnection) {
            commands = ((StatefulRedisConnection)connection).async();
        } else if (connection instanceof StatefulRedisClusterConnection) {
            commands = ((StatefulRedisClusterConnection)connection).async();
        } else {
            throw new ConfigurationException(INVALID_REDIS_CONNECTION_MESSAGE);
        }
        return commands;
    }

    protected RedisStringCommands<byte[], byte[]> getRedisStringCommands(StatefulConnection<byte[], byte[]> connection) {
        RedisCommands commands;
        if (connection instanceof StatefulRedisConnection) {
            commands = ((StatefulRedisConnection)connection).sync();
        } else if (connection instanceof StatefulRedisClusterConnection) {
            commands = ((StatefulRedisClusterConnection)connection).sync();
        } else {
            throw new ConfigurationException(INVALID_REDIS_CONNECTION_MESSAGE);
        }
        return commands;
    }

    protected RedisKeyCommands<byte[], byte[]> getRedisKeyCommands(StatefulConnection<byte[], byte[]> connection) {
        RedisCommands commands;
        if (connection instanceof StatefulRedisConnection) {
            commands = ((StatefulRedisConnection)connection).sync();
        } else if (connection instanceof StatefulRedisClusterConnection) {
            commands = ((StatefulRedisClusterConnection)connection).sync();
        } else {
            throw new ConfigurationException(INVALID_REDIS_CONNECTION_MESSAGE);
        }
        return commands;
    }

    protected abstract <T> Optional<T> getValue(Argument<T> var1, byte[] var2);

    protected abstract <T> void putValue(byte[] var1, T var2);

    protected <T> void putValue(byte[] serializedKey, Optional<byte[]> serialized, ExpirationAfterWritePolicy policy, RedisStringCommands<byte[], byte[]> redisStringCommands, RedisKeyCommands<byte[], byte[]> redisKeyCommands, T value) {
        if (serialized.isPresent()) {
            byte[] bytes = serialized.get();
            if (policy != null) {
                redisStringCommands.psetex((Object)serializedKey, this.expireAfterWritePolicy.getExpirationAfterWrite(value), (Object)bytes);
            } else {
                redisStringCommands.set((Object)serializedKey, (Object)bytes);
            }
        } else {
            redisKeyCommands.del((Object[])new byte[][]{serializedKey});
        }
    }

    protected String getKeysPattern() {
        return this.getName() + ":*";
    }

    protected byte[] serializeKey(Object key) {
        return (byte[])this.keySerializer.serialize(key).orElseThrow(() -> new IllegalArgumentException("Key cannot be null"));
    }

    private ExpirationAfterWritePolicy configureExpirationAfterWritePolicy(AbstractRedisCacheConfiguration redisCacheConfiguration, BeanLocator beanLocator) {
        Optional<Duration> expireAfterWrite = redisCacheConfiguration.getExpireAfterWrite();
        Optional<String> expirationAfterWritePolicy = redisCacheConfiguration.getExpirationAfterWritePolicy();
        if (expireAfterWrite.isPresent()) {
            Duration expiration = expireAfterWrite.get();
            return new ConstantExpirationAfterWritePolicy(expiration.toMillis());
        }
        if (expirationAfterWritePolicy.isPresent()) {
            Optional<ExpirationAfterWritePolicy> policy = expirationAfterWritePolicy.map(className -> this.findExpirationAfterWritePolicyBean(beanLocator, (String)className));
            return policy.orElseThrow(() -> new IllegalArgumentException("Unknown policy " + String.valueOf(expirationAfterWritePolicy)));
        }
        return null;
    }

    private ExpirationAfterWritePolicy findExpirationAfterWritePolicyBean(BeanLocator beanLocator, String className) {
        try {
            Optional bean = beanLocator.findOrInstantiateBean(Class.forName(className));
            if (bean.isPresent()) {
                Object foundBean = bean.get();
                if (foundBean instanceof ExpirationAfterWritePolicy) {
                    return (ExpirationAfterWritePolicy)foundBean;
                }
                throw new ConfigurationException("Redis expiration-after-write-policy was not of type ExpirationAfterWritePolicy");
            }
            throw new ConfigurationException("Redis expiration-after-write-policy was not found");
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Redis expiration-after-write-policy was not found");
        }
    }

    private DefaultStringKeySerializer newDefaultKeySerializer(RedisCacheConfiguration redisCacheConfiguration, ConversionService conversionService) {
        return new DefaultStringKeySerializer(redisCacheConfiguration.getCacheName(), redisCacheConfiguration.getCharset(), conversionService);
    }
}

