/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.lettuce.health;

import io.lettuce.core.RedisClient;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.reactive.BaseRedisReactiveCommands;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.health.HealthStatus;
import io.micronaut.management.health.aggregator.HealthAggregator;
import io.micronaut.management.health.indicator.HealthIndicator;
import io.micronaut.management.health.indicator.HealthResult;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Singleton
@Requirements(value={@Requires(classes={HealthIndicator.class}), @Requires(property="redis.health.enabled", defaultValue="true", notEquals="false")})
public class RedisHealthIndicator
implements HealthIndicator {
    public static final Logger LOG = LoggerFactory.getLogger(RedisHealthIndicator.class);
    public static final String NAME = "redis";
    private static final int TIMEOUT_SECONDS = 3;
    private static final int RETRY = 3;
    private final BeanContext beanContext;
    private final Scheduler scheduler;
    private final HealthAggregator<?> healthAggregator;
    private final RedisClient[] redisClients;
    private final RedisClusterClient[] redisClusterClients;

    @Inject
    public RedisHealthIndicator(BeanContext beanContext, @Named(value="io") ExecutorService executorService, HealthAggregator<?> healthAggregator, RedisClient[] redisClients, RedisClusterClient[] redisClusterClients) {
        this.beanContext = beanContext;
        this.healthAggregator = healthAggregator;
        this.scheduler = Schedulers.fromExecutorService((ExecutorService)executorService);
        this.redisClients = redisClients;
        this.redisClusterClients = redisClusterClients;
    }

    @Deprecated
    public RedisHealthIndicator(BeanContext beanContext, HealthAggregator<?> healthAggregator, RedisClient[] redisClients, RedisClusterClient[] redisClusterClients) {
        this.beanContext = beanContext;
        this.healthAggregator = healthAggregator;
        this.scheduler = Schedulers.immediate();
        this.redisClients = redisClients;
        this.redisClusterClients = redisClusterClients;
    }

    public Publisher<HealthResult> getResult() {
        Flux<HealthResult> clientResults = this.getResult(RedisClient.class, RedisClient::connect, StatefulRedisConnection::reactive);
        Flux<HealthResult> clusteredClientResults = this.getResult(RedisClusterClient.class, RedisClusterClient::connect, StatefulRedisClusterConnection::reactive);
        return this.healthAggregator.aggregate(NAME, (Publisher)Flux.concat((Publisher[])new Publisher[]{clientResults, clusteredClientResults}));
    }

    private <T, R extends StatefulConnection<K, V>, K, V> Flux<HealthResult> getResult(Class<T> type, Function<T, R> getConnection, Function<R, BaseRedisReactiveCommands<K, V>> getReactive) {
        Collection registrations = this.beanContext.getActiveBeanRegistrations(type);
        Flux redisClients = Flux.fromIterable((Iterable)registrations);
        return redisClients.flatMap(client -> this.healthResultForClient((BeanRegistration)client, getConnection, getReactive)).subscribeOn(this.scheduler);
    }

    private <T, R extends StatefulConnection<K, V>, K, V> Mono<HealthResult> healthResultForClient(BeanRegistration<T> client, Function<T, R> getConnection, Function<R, BaseRedisReactiveCommands<K, V>> getReactive) {
        StatefulConnection connection;
        String connectionName = client.getIdentifier().getName();
        String dbName = "redis(" + connectionName + ")";
        try {
            connection = (StatefulConnection)getConnection.apply(client.getBean());
        }
        catch (Exception e) {
            return Mono.just((Object)this.healthResultForThrowable(e, dbName));
        }
        Mono pingCommand = getReactive.apply(connection).ping();
        pingCommand = pingCommand.timeout(Duration.ofSeconds(3L)).retry(3L);
        return pingCommand.map(s -> this.healthResultForPingResponse((String)s, dbName)).onErrorResume(throwable -> Mono.just((Object)this.healthResultForThrowable((Throwable)throwable, dbName))).doFinally(f -> this.closeOnSignal((StatefulConnection)connection, (SignalType)f));
    }

    private <R extends StatefulConnection<K, V>, K, V> void closeOnSignal(R connection, SignalType signalType) {
        try {
            LOG.trace("Closing connection on signal " + String.valueOf(signalType));
            connection.close();
        }
        catch (Exception e) {
            LOG.error("Failed to close connection", (Throwable)e);
        }
    }

    private HealthResult healthResultForThrowable(Throwable throwable, String name) {
        return HealthResult.builder((String)name, (HealthStatus)HealthStatus.DOWN).exception(throwable).build();
    }

    private HealthResult healthResultForPingResponse(String pingResponse, String name) {
        if (pingResponse.equalsIgnoreCase("pong")) {
            return HealthResult.builder((String)name, (HealthStatus)HealthStatus.UP).build();
        }
        return HealthResult.builder((String)name, (HealthStatus)HealthStatus.DOWN).details(Collections.singletonMap("message", "Unexpected response: " + pingResponse)).build();
    }
}

