/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.processor.ExecutableMethodProcessor;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.reflect.ClassLoadingReporter;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Error;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Head;
import io.micronaut.http.annotation.HttpMethodMapping;
import io.micronaut.http.annotation.Options;
import io.micronaut.http.annotation.Patch;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.Put;
import io.micronaut.http.annotation.Trace;
import io.micronaut.http.uri.UriTemplate;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.web.router.DefaultRouteBuilder;
import io.micronaut.web.router.Route;
import io.micronaut.web.router.RouteBuilder;
import io.micronaut.web.router.UriRoute;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.inject.Singleton;

@Singleton
public class AnnotatedMethodRouteBuilder
extends DefaultRouteBuilder
implements ExecutableMethodProcessor<Controller> {
    private final Map<Class, BiConsumer<BeanDefinition, ExecutableMethod>> httpMethodsHandlers = new LinkedHashMap<Class, BiConsumer<BeanDefinition, ExecutableMethod>>();

    public AnnotatedMethodRouteBuilder(ExecutionHandleLocator executionHandleLocator, RouteBuilder.UriNamingStrategy uriNamingStrategy, ConversionService<?> conversionService) {
        super(executionHandleLocator, uriNamingStrategy, conversionService);
        this.httpMethodsHandlers.put(Get.class, (bean, method) -> {
            AnnotationValue mapping = method.getAnnotation(HttpMethodMapping.class);
            String uri = (String)mapping.getRequiredValue(String.class);
            MediaType[] produces = method.getValue(Produces.class, MediaType[].class).orElse(null);
            UriRoute route = this.GET(this.resolveUri((BeanDefinition)bean, uri, (ExecutableMethod)method, uriNamingStrategy), method.getDeclaringType(), method.getMethodName(), method.getArgumentTypes()).produces(produces);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created Route: {}", (Object)route);
            }
        });
        this.httpMethodsHandlers.put(Post.class, (bean, method) -> {
            AnnotationValue mapping = method.getAnnotation(HttpMethodMapping.class);
            String uri = (String)mapping.getRequiredValue(String.class);
            MediaType[] consumes = method.getValue(Consumes.class, MediaType[].class).orElse(null);
            MediaType[] produces = method.getValue(Produces.class, MediaType[].class).orElse(null);
            Route route = this.POST(this.resolveUri((BeanDefinition)bean, uri, (ExecutableMethod)method, uriNamingStrategy), method.getDeclaringType(), method.getMethodName(), method.getArgumentTypes());
            route = route.consumes(consumes).produces(produces);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created Route: {}", (Object)route);
            }
        });
        this.httpMethodsHandlers.put(Put.class, (bean, method) -> {
            AnnotationValue mapping = method.getAnnotation(HttpMethodMapping.class);
            String uri = (String)mapping.getRequiredValue(String.class);
            MediaType[] consumes = method.getValue(Consumes.class, MediaType[].class).orElse(null);
            MediaType[] produces = method.getValue(Produces.class, MediaType[].class).orElse(null);
            Route route = this.PUT(this.resolveUri((BeanDefinition)bean, uri, (ExecutableMethod)method, uriNamingStrategy), method.getDeclaringType(), method.getMethodName(), method.getArgumentTypes());
            route = route.consumes(consumes).produces(produces);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created Route: {}", (Object)route);
            }
        });
        this.httpMethodsHandlers.put(Patch.class, (bean, method) -> {
            AnnotationValue mapping = method.getAnnotation(HttpMethodMapping.class);
            String uri = (String)mapping.getRequiredValue(String.class);
            MediaType[] consumes = method.getValue(Consumes.class, MediaType[].class).orElse(null);
            MediaType[] produces = method.getValue(Produces.class, MediaType[].class).orElse(null);
            Route route = this.PATCH(this.resolveUri((BeanDefinition)bean, uri, (ExecutableMethod)method, uriNamingStrategy), method.getDeclaringType(), method.getMethodName(), method.getArgumentTypes());
            route = route.consumes(consumes).produces(produces);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created Route: {}", (Object)route);
            }
        });
        this.httpMethodsHandlers.put(Delete.class, (bean, method) -> {
            AnnotationValue mapping = method.getAnnotation(HttpMethodMapping.class);
            String uri = (String)mapping.getRequiredValue(String.class);
            MediaType[] consumes = method.getValue(Consumes.class, MediaType[].class).orElse(null);
            MediaType[] produces = method.getValue(Produces.class, MediaType[].class).orElse(null);
            Route route = this.DELETE(this.resolveUri((BeanDefinition)bean, uri, (ExecutableMethod)method, uriNamingStrategy), method.getDeclaringType(), method.getMethodName(), method.getArgumentTypes());
            route = route.consumes(consumes).produces(produces);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created Route: {}", (Object)route);
            }
        });
        this.httpMethodsHandlers.put(Head.class, (bean, method) -> {
            AnnotationValue mapping = method.getAnnotation(HttpMethodMapping.class);
            String uri = (String)mapping.getRequiredValue(String.class);
            UriRoute route = this.HEAD(this.resolveUri((BeanDefinition)bean, uri, (ExecutableMethod)method, uriNamingStrategy), method.getDeclaringType(), method.getMethodName(), method.getArgumentTypes());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created Route: {}", (Object)route);
            }
        });
        this.httpMethodsHandlers.put(Options.class, (bean, method) -> {
            AnnotationValue mapping = method.getAnnotation(HttpMethodMapping.class);
            String uri = (String)mapping.getRequiredValue(String.class);
            MediaType[] consumes = method.getValue(Consumes.class, MediaType[].class).orElse(null);
            MediaType[] produces = method.getValue(Produces.class, MediaType[].class).orElse(null);
            Route route = this.OPTIONS(this.resolveUri((BeanDefinition)bean, uri, (ExecutableMethod)method, uriNamingStrategy), method.getDeclaringType(), method.getMethodName(), method.getArgumentTypes());
            route = route.consumes(consumes).produces(produces);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created Route: {}", (Object)route);
            }
        });
        this.httpMethodsHandlers.put(Trace.class, (bean, method) -> {
            AnnotationValue mapping = method.getAnnotation(HttpMethodMapping.class);
            String uri = (String)mapping.getRequiredValue(String.class);
            UriRoute route = this.TRACE(this.resolveUri((BeanDefinition)bean, uri, (ExecutableMethod)method, uriNamingStrategy), method.getDeclaringType(), method.getMethodName(), method.getArgumentTypes());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created Route: {}", (Object)route);
            }
        });
        this.httpMethodsHandlers.put(Error.class, (bean, method) -> {
            boolean isGlobal = method.getValue(Error.class, "global", Boolean.TYPE).orElse(false);
            Class declaringType = method.getDeclaringType();
            if (method.isPresent(Error.class, "status")) {
                Optional value = method.getValue(Error.class, "status", HttpStatus.class);
                value.ifPresent(httpStatus -> {
                    if (isGlobal) {
                        this.status((HttpStatus)httpStatus, declaringType, method.getMethodName(), method.getArgumentTypes());
                    } else {
                        this.status(declaringType, (HttpStatus)httpStatus, declaringType, method.getMethodName(), method.getArgumentTypes());
                    }
                });
            } else {
                Optional annotationValue;
                Class exceptionType = null;
                if (method.isPresent(Error.class, "value") && (annotationValue = method.classValue(Error.class)).isPresent() && Throwable.class.isAssignableFrom((Class)annotationValue.get())) {
                    exceptionType = (Class)annotationValue.get();
                }
                if (exceptionType == null) {
                    exceptionType = Arrays.stream(method.getArgumentTypes()).filter(Throwable.class::isAssignableFrom).findFirst().orElse(Throwable.class);
                }
                if (isGlobal) {
                    this.error(exceptionType, declaringType, method.getMethodName(), method.getArgumentTypes());
                } else {
                    this.error(declaringType, exceptionType, declaringType, method.getMethodName(), method.getArgumentTypes());
                }
            }
        });
    }

    public void process(BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        Optional actionAnn = method.getAnnotationTypeByStereotype(HttpMethodMapping.class);
        actionAnn.ifPresent(annotationClass -> {
            BiConsumer<BeanDefinition, ExecutableMethod> handler = this.httpMethodsHandlers.get(annotationClass);
            if (handler != null) {
                ClassLoadingReporter.reportBeanPresent((Class)method.getReturnType().getType());
                for (Class argumentType : method.getArgumentTypes()) {
                    ClassLoadingReporter.reportBeanPresent((Class)argumentType);
                }
                handler.accept(beanDefinition, method);
            }
        });
    }

    private String resolveUri(BeanDefinition bean, String value, ExecutableMethod method, RouteBuilder.UriNamingStrategy uriNamingStrategy) {
        UriTemplate rootUri = UriTemplate.of((String)uriNamingStrategy.resolveUri(bean));
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            return rootUri.nest((CharSequence)value).toString();
        }
        return rootUri.nest((CharSequence)uriNamingStrategy.resolveUri(method.getMethodName())).toString();
    }
}

