/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.uri.UriMatchInfo;
import io.micronaut.http.uri.UriMatchVariable;
import io.micronaut.web.router.AbstractRouteMatch;
import io.micronaut.web.router.DefaultRouteBuilder;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.UriRoute;
import io.micronaut.web.router.UriRouteMatch;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

@Internal
class DefaultUriRouteMatch<T, R>
extends AbstractRouteMatch<T, R>
implements UriRouteMatch<T, R> {
    private final HttpMethod httpMethod;
    private final UriMatchInfo matchInfo;
    private final DefaultRouteBuilder.DefaultUriRoute uriRoute;
    private final Charset defaultCharset;

    DefaultUriRouteMatch(UriMatchInfo matchInfo, DefaultRouteBuilder.DefaultUriRoute uriRoute, Charset defaultCharset, ConversionService<?> conversionService) {
        super(uriRoute, conversionService);
        this.uriRoute = uriRoute;
        this.matchInfo = matchInfo;
        this.httpMethod = uriRoute.httpMethod;
        this.defaultCharset = defaultCharset;
    }

    @Override
    public UriRouteMatch<T, R> decorate(final Function<RouteMatch<R>, R> executor) {
        final Map<String, Object> variables = this.getVariableValues();
        final List arguments = this.getRequiredArguments();
        final DefaultUriRouteMatch thisRoute = this;
        return new DefaultUriRouteMatch<T, R>(this.matchInfo, this.uriRoute, this.defaultCharset, this.conversionService){

            @Override
            public List<Argument> getRequiredArguments() {
                return Collections.unmodifiableList(arguments);
            }

            @Override
            public R execute(Map argumentValues) {
                return executor.apply(thisRoute);
            }

            @Override
            public Map<String, Object> getVariableValues() {
                return variables;
            }
        };
    }

    @Override
    protected RouteMatch<R> newFulfilled(final Map<String, Object> newVariables, final List<Argument> requiredArguments) {
        return new DefaultUriRouteMatch<T, R>(this.matchInfo, this.uriRoute, this.defaultCharset, this.conversionService){

            @Override
            public List<Argument> getRequiredArguments() {
                return Collections.unmodifiableList(requiredArguments);
            }

            @Override
            public Map<String, Object> getVariableValues() {
                return newVariables;
            }

            @Override
            public Optional<Argument<?>> getRequiredInput(String name) {
                return super.getRequiredInput(name);
            }
        };
    }

    @Override
    public UriRouteMatch<T, R> fulfill(Map<String, Object> argumentValues) {
        return (UriRouteMatch)super.fulfill(argumentValues);
    }

    public String getUri() {
        return this.matchInfo.getUri();
    }

    @Override
    public Map<String, Object> getVariableValues() {
        Map variables = this.matchInfo.getVariableValues();
        LinkedHashMap<String, Object> decoded = new LinkedHashMap<String, Object>(variables.size());
        for (Map.Entry entry : variables.entrySet()) {
            String k = (String)entry.getKey();
            Object v = entry.getValue();
            if (v instanceof CharSequence) {
                try {
                    v = URLDecoder.decode(v.toString(), this.defaultCharset.toString());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            decoded.put(k, v);
        }
        return decoded;
    }

    public List<UriMatchVariable> getVariables() {
        return this.matchInfo.getVariables();
    }

    @Override
    public UriRoute getRoute() {
        return (UriRoute)((Object)this.abstractRoute);
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String toString() {
        return this.httpMethod + " - " + this.matchInfo.getUri();
    }
}

