/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.filter.HttpFilter;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.UriRoute;
import io.micronaut.web.router.UriRouteMatch;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public interface Router {
    public <T, R> Stream<UriRouteMatch<T, R>> findAny(CharSequence var1);

    public <T, R> Stream<UriRouteMatch<T, R>> find(HttpMethod var1, CharSequence var2);

    public Stream<UriRoute> uriRoutes();

    public <T, R> Optional<UriRouteMatch<T, R>> route(HttpMethod var1, CharSequence var2);

    public <R> Optional<RouteMatch<R>> route(HttpStatus var1);

    public <R> Optional<RouteMatch<R>> route(Class var1, HttpStatus var2);

    public <R> Optional<RouteMatch<R>> route(Throwable var1);

    public <R> Optional<RouteMatch<R>> route(Class var1, Throwable var2);

    public List<HttpFilter> findFilters(HttpRequest<?> var1);

    default public <T, R> Optional<UriRouteMatch<T, R>> GET(CharSequence uri) {
        return this.route(HttpMethod.GET, uri);
    }

    default public <T, R> Optional<UriRouteMatch<T, R>> POST(CharSequence uri) {
        return this.route(HttpMethod.POST, uri);
    }

    default public <T, R> Optional<UriRouteMatch<T, R>> PUT(CharSequence uri) {
        return this.route(HttpMethod.PUT, uri);
    }

    default public <T, R> Optional<UriRouteMatch<T, R>> PATCH(CharSequence uri) {
        return this.route(HttpMethod.PATCH, uri);
    }

    default public <T, R> Optional<UriRouteMatch<T, R>> DELETE(CharSequence uri) {
        return this.route(HttpMethod.DELETE, uri);
    }

    default public <T, R> Optional<UriRouteMatch<T, R>> OPTIONS(CharSequence uri) {
        return this.route(HttpMethod.OPTIONS, uri);
    }

    default public <T, R> Optional<UriRouteMatch<T, R>> HEAD(CharSequence uri) {
        return this.route(HttpMethod.HEAD, uri);
    }

    default public <T, R> Stream<UriRouteMatch<T, R>> find(HttpMethod httpMethod, URI uri) {
        return this.find(httpMethod, uri.toString());
    }
}

