/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router.naming;

import io.micronaut.context.annotation.Primary;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.naming.conventions.TypeConvention;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.annotation.Controller;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ProxyBeanDefinition;
import io.micronaut.web.router.RouteBuilder;
import javax.inject.Singleton;

@Singleton
@Primary
public class HyphenatedUriNamingStrategy
implements RouteBuilder.UriNamingStrategy {
    public String resolveUri(Class type) {
        return '/' + TypeConvention.CONTROLLER.asHyphenatedName(type);
    }

    @Override
    public String resolveUri(BeanDefinition<?> beanDefinition) {
        Class beanType;
        String uri = this.normalizeUri(beanDefinition.getValue(Controller.class, String.class).orElse(null));
        if (uri != null) {
            return uri;
        }
        if (beanDefinition instanceof ProxyBeanDefinition) {
            ProxyBeanDefinition pbd = (ProxyBeanDefinition)beanDefinition;
            beanType = pbd.getTargetType();
        } else {
            beanType = beanDefinition.getBeanType();
        }
        return '/' + TypeConvention.CONTROLLER.asHyphenatedName(beanType);
    }

    @Override
    public String resolveUri(String property) {
        if (StringUtils.isEmpty((CharSequence)property)) {
            return "/";
        }
        if (property.charAt(0) != '/') {
            return '/' + NameUtils.hyphenate((String)property, (boolean)true);
        }
        return property;
    }
}

