/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router.resource;

import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.Toggleable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@EachProperty(value="micronaut.router.static-resources")
public class StaticResourceConfiguration
implements Toggleable {
    public static final String PREFIX = "micronaut.router.static-resources";
    public static final boolean DEFAULT_ENABLED = true;
    public static final String DEFAULT_MAPPING = "/**";
    private boolean enabled = true;
    private List<String> paths = Collections.emptyList();
    private String mapping = "/**";
    private final ResourceResolver resourceResolver;

    public StaticResourceConfiguration(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<ResourceLoader> getResourceLoaders() {
        if (this.enabled) {
            ArrayList<ResourceLoader> loaders = new ArrayList<ResourceLoader>(this.paths.size());
            for (String path : this.paths) {
                if (path.equals("classpath:")) {
                    throw new ConfigurationException("A path value of [classpath:] will allow access to class files!");
                }
                Optional loader = this.resourceResolver.getLoaderForBasePath(path);
                if (loader.isPresent()) {
                    loaders.add((ResourceLoader)loader.get());
                    continue;
                }
                throw new ConfigurationException("Unrecognizable resource path: " + path);
            }
            return loaders;
        }
        return Collections.emptyList();
    }

    public String getMapping() {
        return this.mapping;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setPaths(List<String> paths) {
        if (CollectionUtils.isNotEmpty(paths)) {
            this.paths = paths;
        }
    }

    public void setMapping(String mapping) {
        if (StringUtils.isNotEmpty((CharSequence)mapping)) {
            this.mapping = mapping;
        }
    }
}

