/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache;

import io.micronaut.cache.CacheManager;
import io.micronaut.cache.SyncCache;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.util.ArrayUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;

@Singleton
@Primary
public class DefaultCacheManager<C>
implements CacheManager<C> {
    private final Map<String, SyncCache<C>> cacheMap;

    public DefaultCacheManager(SyncCache<C> ... caches) {
        if (ArrayUtils.isEmpty((Object[])caches)) {
            this.cacheMap = Collections.emptyMap();
        } else {
            this.cacheMap = new LinkedHashMap<String, SyncCache<C>>(caches.length);
            for (SyncCache<C> cache : caches) {
                this.cacheMap.put(cache.getName(), cache);
            }
        }
    }

    @Override
    public Set<String> getCacheNames() {
        return this.cacheMap.keySet();
    }

    @Override
    public SyncCache<C> getCache(String name) {
        SyncCache<C> cache = this.cacheMap.get(name);
        if (cache == null) {
            throw new ConfigurationException("No cache configured for name: " + name);
        }
        return cache;
    }
}

