/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery;

import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.ServiceInstanceList;
import io.micronaut.health.HealthStatus;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class StaticServiceInstanceList
implements ServiceInstanceList {
    private final String id;
    private final Collection<URI> loadBalancedURIs;

    public StaticServiceInstanceList(String id, Collection<URI> loadBalancedURIs) {
        this.id = id;
        this.loadBalancedURIs = loadBalancedURIs;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public List<ServiceInstance> getInstances() {
        return this.loadBalancedURIs.stream().map(url -> {
            ServiceInstance.Builder builder = ServiceInstance.builder(this.id, url);
            builder.status(HealthStatus.UP);
            return builder.build();
        }).collect(Collectors.toList());
    }
}

