/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.cloud.aws;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.core.io.IOUtils;
import io.micronaut.discovery.cloud.ComputeInstanceMetadata;
import io.micronaut.discovery.cloud.ComputeInstanceMetadataResolver;
import io.micronaut.discovery.cloud.NetworkInterface;
import io.micronaut.discovery.cloud.aws.AmazonEC2InstanceMetadata;
import io.micronaut.discovery.cloud.aws.AmazonMetadataConfiguration;
import io.micronaut.discovery.cloud.aws.AmazonNetworkInterface;
import io.micronaut.discovery.cloud.aws.EC2MetadataKeys;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(env={"ec2"})
public class AmazonComputeInstanceMetadataResolver
implements ComputeInstanceMetadataResolver {
    private static final Logger LOG = LoggerFactory.getLogger(AmazonComputeInstanceMetadataResolver.class);
    private static final int READ_TIMEOUT_IN_MILLS = 5000;
    private static final int CONNECTION_TIMEOUT_IN_MILLS = 5000;
    private final ObjectMapper objectMapper;
    private final AmazonMetadataConfiguration configuration;
    private AmazonEC2InstanceMetadata cachedMetadata;

    @Inject
    public AmazonComputeInstanceMetadataResolver(ObjectMapper objectMapper, AmazonMetadataConfiguration configuration) {
        this.objectMapper = objectMapper;
        this.configuration = configuration;
    }

    public AmazonComputeInstanceMetadataResolver() {
        this.objectMapper = new ObjectMapper();
        this.configuration = new AmazonMetadataConfiguration();
    }

    @Override
    public Optional<ComputeInstanceMetadata> resolve(Environment environment) {
        if (!this.configuration.isEnabled()) {
            return Optional.empty();
        }
        if (this.cachedMetadata != null) {
            this.cachedMetadata.cached = true;
            return Optional.of(this.cachedMetadata);
        }
        AmazonEC2InstanceMetadata ec2InstanceMetadata = new AmazonEC2InstanceMetadata();
        try {
            String ec2InstanceIdentityDocURL = this.configuration.getInstanceDocumentUrl();
            String ec2InstanceMetadataURL = this.configuration.getMetadataUrl();
            JsonNode metadataJson = this.readEc2MetadataJson(new URL(ec2InstanceIdentityDocURL), 5000, 5000);
            if (metadataJson != null) {
                ec2InstanceMetadata.account = metadataJson.findValue(EC2MetadataKeys.accountId.name()).textValue();
                ec2InstanceMetadata.availabilityZone = metadataJson.findValue(EC2MetadataKeys.availabilityZone.name()).textValue();
                ec2InstanceMetadata.instanceId = metadataJson.findValue(EC2MetadataKeys.instanceId.name()).textValue();
                ec2InstanceMetadata.machineType = metadataJson.findValue(EC2MetadataKeys.instanceType.name()).textValue();
                ec2InstanceMetadata.region = metadataJson.findValue(EC2MetadataKeys.region.name()).textValue();
                ec2InstanceMetadata.privateIpV4 = metadataJson.findValue("privateIp").textValue();
                ec2InstanceMetadata.imageId = metadataJson.findValue("imageId").textValue();
            }
            try {
                ec2InstanceMetadata.localHostname = this.readEc2MetadataUrl(new URL(ec2InstanceMetadataURL + EC2MetadataKeys.localHostname.getName()), 5000, 5000);
            }
            catch (IOException e) {
                LOG.error("Error getting local hostname from url:" + ec2InstanceMetadataURL + EC2MetadataKeys.localHostname.name(), (Throwable)e);
            }
            try {
                ec2InstanceMetadata.publicHostname = this.readEc2MetadataUrl(new URL(ec2InstanceMetadataURL + EC2MetadataKeys.publicHostname.getName()), 5000, 5000);
            }
            catch (IOException e) {
                LOG.error("error getting public host name from:" + ec2InstanceMetadataURL + EC2MetadataKeys.publicHostname.name(), (Throwable)e);
            }
            try {
                String macAddress = this.readEc2MetadataUrl(new URL(ec2InstanceMetadataURL + (Object)((Object)EC2MetadataKeys.mac)), 5000, 5000);
                AmazonNetworkInterface networkInterface = new AmazonNetworkInterface();
                networkInterface.setMac(macAddress);
                String vpcId = this.readEc2MetadataUrl(new URL(ec2InstanceMetadataURL + "/network/interfaces/macs/" + macAddress + "/vpc-id/"), 5000, 5000);
                String subnetId = this.readEc2MetadataUrl(new URL(ec2InstanceMetadataURL + "/network/interfaces/macs/" + macAddress + "/subnet-id/"), 5000, 5000);
                networkInterface.setNetwork(subnetId);
                ec2InstanceMetadata.publicIpV4 = this.readEc2MetadataUrl(new URL(ec2InstanceMetadataURL + "/network/interfaces/macs/" + macAddress + "/public-ipv4s/"), 5000, 5000);
                ec2InstanceMetadata.privateIpV4 = this.readEc2MetadataUrl(new URL(ec2InstanceMetadataURL + "/network/interfaces/macs/" + macAddress + "/local-ipv4s/"), 5000, 5000);
                networkInterface.setIpv4(ec2InstanceMetadata.privateIpV4);
                networkInterface.setId(this.readEc2MetadataUrl(new URL(ec2InstanceMetadataURL + "/network/interfaces/macs/" + macAddress + "/interface-id/"), 5000, 5000));
                networkInterface.setGateway(vpcId);
                ec2InstanceMetadata.interfaces = new ArrayList<NetworkInterface>();
                ec2InstanceMetadata.interfaces.add(networkInterface);
            }
            catch (IOException e) {
                LOG.error("error getting public host name from:" + ec2InstanceMetadataURL + EC2MetadataKeys.publicHostname.getName(), (Throwable)e);
            }
            ec2InstanceMetadata.metadata = (Map)this.objectMapper.convertValue((Object)ec2InstanceMetadata, Map.class);
            if (LOG.isDebugEnabled()) {
                LOG.debug("EC2 Metadata found:" + ec2InstanceMetadata.metadata.toString());
            }
        }
        catch (IOException e) {
            LOG.error("Error reading ec2 metadata url", (Throwable)e);
        }
        this.cachedMetadata = ec2InstanceMetadata;
        return Optional.of(ec2InstanceMetadata);
    }

    protected JsonNode readEc2MetadataJson(URL url, int connectionTimeoutMs, int readTimeoutMs) throws IOException {
        URLConnection urlConnection = url.openConnection();
        if (url.getProtocol().equalsIgnoreCase("file")) {
            urlConnection.connect();
            try (InputStream in = urlConnection.getInputStream();){
                JsonNode jsonNode = this.objectMapper.readTree(in);
                return jsonNode;
            }
        }
        HttpURLConnection uc = (HttpURLConnection)urlConnection;
        uc.setConnectTimeout(connectionTimeoutMs);
        uc.setReadTimeout(readTimeoutMs);
        uc.setRequestMethod("GET");
        uc.setDoOutput(true);
        int responseCode = uc.getResponseCode();
        try (InputStream in = uc.getInputStream();){
            JsonNode jsonNode = this.objectMapper.readTree(in);
            return jsonNode;
        }
    }

    protected String readEc2MetadataUrl(URL url, int connectionTimeoutMs, int readTimeoutMs) throws IOException {
        URLConnection urlConnection = url.openConnection();
        if (url.getProtocol().equalsIgnoreCase("file")) {
            if (url.getPath().indexOf(58) != -1) {
                url = new URL(url.getProtocol(), url.getHost(), url.getFile().replace(':', '_'));
                urlConnection = url.openConnection();
            }
            urlConnection.connect();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));){
                String string = IOUtils.readText((BufferedReader)in);
                return string;
            }
        }
        HttpURLConnection uc = (HttpURLConnection)urlConnection;
        uc.setConnectTimeout(connectionTimeoutMs);
        uc.setReadTimeout(readTimeoutMs);
        uc.setRequestMethod("GET");
        uc.setDoOutput(true);
        int responseCode = uc.getResponseCode();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(uc.getInputStream()));){
            String string = IOUtils.readText((BufferedReader)in);
            return string;
        }
    }
}

