/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.config;

import io.micronaut.context.annotation.Primary;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.core.naming.Described;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.discovery.config.ConfigurationClient;
import io.reactivex.Flowable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;

@Singleton
@Primary
public class DefaultCompositeConfigurationClient
implements ConfigurationClient {
    private final ConfigurationClient[] configurationClients;

    public DefaultCompositeConfigurationClient(ConfigurationClient[] configurationClients) {
        this.configurationClients = configurationClients;
    }

    public String getDescription() {
        return this.toString();
    }

    @Override
    public Publisher<PropertySource> getPropertySources(Environment environment) {
        if (ArrayUtils.isEmpty((Object[])this.configurationClients)) {
            return Flowable.empty();
        }
        List publishers = Arrays.stream(this.configurationClients).map(configurationClient -> configurationClient.getPropertySources(environment)).collect(Collectors.toList());
        return Flowable.merge(publishers);
    }

    public String toString() {
        return "compositeConfigurationClient(" + Arrays.stream(this.configurationClients).map(Described::getDescription).collect(Collectors.joining(",")) + ")";
    }
}

