/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Type;
import io.micronaut.core.reflect.GenericTypeUtils;
import io.micronaut.jackson.JacksonConfiguration;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import javax.inject.Inject;
import javax.inject.Singleton;

@Factory
public class ObjectMapperFactory {
    public static final String MICRONAUT_MODULE = "micronaut";
    @Inject
    protected Module[] jacksonModules = new Module[0];
    @Inject
    protected JsonSerializer[] serializers = new JsonSerializer[0];
    @Inject
    protected JsonDeserializer[] deserializers = new JsonDeserializer[0];
    @Inject
    protected BeanSerializerModifier[] beanSerializerModifiers = new BeanSerializerModifier[0];
    @Inject
    protected BeanDeserializerModifier[] beanDeserializerModifiers = new BeanDeserializerModifier[0];

    @Bean
    @Singleton
    public ObjectMapper objectMapper(Optional<JacksonConfiguration> jacksonConfiguration, Optional<JsonFactory> jsonFactory) {
        Optional targetType;
        Class[] value;
        Type annotation;
        Class<?> type;
        ObjectMapper objectMapper = jsonFactory.map(ObjectMapper::new).orElseGet(ObjectMapper::new);
        objectMapper.findAndRegisterModules();
        objectMapper.registerModules(this.jacksonModules);
        SimpleModule module = new SimpleModule(MICRONAUT_MODULE);
        for (JsonSerializer jsonSerializer : this.serializers) {
            type = jsonSerializer.getClass();
            annotation = type.getAnnotation(Type.class);
            if (annotation != null) {
                for (Class aClass : value = annotation.value()) {
                    module.addSerializer(aClass, jsonSerializer);
                }
                continue;
            }
            targetType = GenericTypeUtils.resolveSuperGenericTypeArgument(type);
            if (targetType.isPresent()) {
                module.addSerializer((Class)targetType.get(), jsonSerializer);
                continue;
            }
            module.addSerializer(jsonSerializer);
        }
        for (JsonSerializer jsonSerializer : this.deserializers) {
            type = jsonSerializer.getClass();
            annotation = type.getAnnotation(Type.class);
            if (annotation != null) {
                for (Class aClass : value = annotation.value()) {
                    module.addDeserializer(aClass, (JsonDeserializer)jsonSerializer);
                }
                continue;
            }
            targetType = GenericTypeUtils.resolveSuperGenericTypeArgument(type);
            targetType.ifPresent(arg_0 -> ObjectMapperFactory.lambda$objectMapper$0(module, (JsonDeserializer)jsonSerializer, arg_0));
        }
        objectMapper.registerModule((Module)module);
        for (JsonSerializer jsonSerializer : this.beanSerializerModifiers) {
            objectMapper.setSerializerFactory(objectMapper.getSerializerFactory().withSerializerModifier((BeanSerializerModifier)jsonSerializer));
        }
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        objectMapper.configure(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS, true);
        jacksonConfiguration.ifPresent(configuration -> {
            TimeZone timeZone;
            Locale locale;
            String dateFormat;
            JsonInclude.Include include = configuration.getSerializationInclusion();
            if (include != null) {
                objectMapper.setSerializationInclusion(include);
            }
            if ((dateFormat = configuration.getDateFormat()) != null) {
                objectMapper.setDateFormat((DateFormat)new SimpleDateFormat(dateFormat));
            }
            if ((locale = configuration.getLocale()) != null) {
                objectMapper.setLocale(locale);
            }
            if ((timeZone = configuration.getTimeZone()) != null) {
                objectMapper.setTimeZone(timeZone);
            }
            configuration.getSerializationSettings().forEach((arg_0, arg_1) -> ((ObjectMapper)objectMapper).configure(arg_0, arg_1));
            configuration.getDeserializationSettings().forEach((arg_0, arg_1) -> ((ObjectMapper)objectMapper).configure(arg_0, arg_1));
            configuration.getMapperSettings().forEach((arg_0, arg_1) -> ((ObjectMapper)objectMapper).configure(arg_0, arg_1));
            configuration.getParserSettings().forEach((arg_0, arg_1) -> ((ObjectMapper)objectMapper).configure(arg_0, arg_1));
            configuration.getGeneratorSettings().forEach((arg_0, arg_1) -> ((ObjectMapper)objectMapper).configure(arg_0, arg_1));
        });
        return objectMapper;
    }

    private static /* synthetic */ void lambda$objectMapper$0(SimpleModule module, JsonDeserializer deserializer, Class aClass) {
        module.addDeserializer(aClass, deserializer);
    }
}

