/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.convert;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.TypeConverter;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
public class ArrayNodeToArrayConverter
implements TypeConverter<ArrayNode, Object[]> {
    private final ObjectMapper objectMapper;

    public ArrayNodeToArrayConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Optional<Object[]> convert(ArrayNode node, Class<Object[]> targetType, ConversionContext context) {
        try {
            Object[] result = (Object[])this.objectMapper.treeToValue((TreeNode)node, targetType);
            return Optional.of(result);
        }
        catch (JsonProcessingException e) {
            context.reject((Exception)((Object)e));
            return Optional.empty();
        }
    }
}

