/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.convert;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.TypeConverter;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
public class ObjectToJsonNodeConverter
implements TypeConverter<Object, JsonNode> {
    private final ObjectMapper objectMapper;

    public ObjectToJsonNodeConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Optional<JsonNode> convert(Object object, Class<JsonNode> targetType, ConversionContext context) {
        try {
            return Optional.of(this.objectMapper.valueToTree(object));
        }
        catch (IllegalArgumentException e) {
            context.reject((Exception)e);
            return Optional.empty();
        }
    }
}

