/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.rxjava2;

import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.scheduling.instrument.RunnableInstrumenter;
import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@Context
@Requires(classes={Flowable.class})
@Internal
class RxJava2Instrumentation
implements Function<Runnable, Runnable> {
    private final List<RunnableInstrumenter> instrumenters;

    public RxJava2Instrumentation(RunnableInstrumenter ... instrumenters) {
        this.instrumenters = Arrays.asList(instrumenters);
    }

    @Inject
    public RxJava2Instrumentation(List<RunnableInstrumenter> instrumenters) {
        this.instrumenters = instrumenters;
    }

    @PostConstruct
    void init() {
        Function existing = RxJavaPlugins.getScheduleHandler();
        if (existing != null && !(existing instanceof RxJava2Instrumentation)) {
            RxJavaPlugins.setScheduleHandler(runnable -> this.apply((Runnable)existing.apply(runnable)));
        } else {
            RxJavaPlugins.setScheduleHandler((Function)this);
        }
    }

    public Runnable apply(Runnable runnable) throws Exception {
        Runnable newRunnable = runnable;
        for (RunnableInstrumenter instrumenter : this.instrumenters) {
            newRunnable = instrumenter.instrument(newRunnable);
        }
        return newRunnable;
    }
}

