/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.retry.intercept;

import io.micronaut.aop.InterceptPhase;
import io.micronaut.aop.Interceptor;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.type.ReturnType;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.retry.RetryState;
import io.micronaut.retry.annotation.CircuitBreaker;
import io.micronaut.retry.annotation.Retryable;
import io.micronaut.retry.event.RetryEvent;
import io.micronaut.retry.intercept.AnnotationRetryStateBuilder;
import io.micronaut.retry.intercept.CircuitBreakerRetry;
import io.micronaut.retry.intercept.MutableRetryState;
import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultRetryInterceptor
implements MethodInterceptor<Object, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRetryInterceptor.class);
    private static final int DEFAULT_CIRCUIT_BREAKER_TIMEOUT_IN_MILLIS = 20;
    private final ApplicationEventPublisher eventPublisher;
    private final Map<ExecutableMethod, CircuitBreakerRetry> circuitContexts = new ConcurrentHashMap<ExecutableMethod, CircuitBreakerRetry>();

    public DefaultRetryInterceptor(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public int getOrder() {
        return InterceptPhase.RETRY.getPosition();
    }

    public Object intercept(MethodInvocationContext<Object, Object> context) {
        MutableRetryState retryState;
        Optional opt = context.findAnnotation(Retryable.class);
        if (!opt.isPresent()) {
            return context.proceed();
        }
        AnnotationValue retry = (AnnotationValue)opt.get();
        boolean isCircuitBreaker = context.hasStereotype(CircuitBreaker.class);
        AnnotationRetryStateBuilder retryStateBuilder = new AnnotationRetryStateBuilder((AnnotationMetadata)context);
        if (isCircuitBreaker) {
            long timeout = context.getValue(CircuitBreaker.class, "reset", Duration.class).map(Duration::toMillis).orElse(Duration.ofSeconds(20L).toMillis());
            retryState = this.circuitContexts.computeIfAbsent(context.getExecutableMethod(), method -> new CircuitBreakerRetry(timeout, retryStateBuilder, (ExecutableMethod<?, ?>)context, this.eventPublisher));
        } else {
            retryState = (MutableRetryState)retryStateBuilder.build();
        }
        retryState.open();
        MutableConvertibleValues attrs = context.getAttributes();
        attrs.put((CharSequence)RetryState.class.getName(), (Object)retry);
        ReturnType returnType = context.getReturnType();
        Class javaReturnType = returnType.getType();
        if (Publishers.isConvertibleToPublisher((Class)javaReturnType)) {
            ConversionService conversionService = ConversionService.SHARED;
            Object result = context.proceed();
            if (result == null) {
                return result;
            }
            Flowable observable = (Flowable)conversionService.convert(result, Flowable.class).orElseThrow(() -> new IllegalStateException("Unconvertible Reactive type: " + result));
            Flowable retryObservable = observable.onErrorResumeNext(this.retryFlowable(context, retryState, observable)).map(o -> {
                retryState.close(null);
                return o;
            });
            return conversionService.convert((Object)retryObservable, returnType.asArgument()).orElseThrow(() -> new IllegalStateException("Unconvertible Reactive type: " + result));
        }
        while (true) {
            try {
                Object result = context.proceed((Interceptor)this);
                retryState.close(null);
                return result;
            }
            catch (RuntimeException e) {
                if (!retryState.canRetry(e)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Cannot retry anymore. Rethrowing original exception for method: {}", context);
                    }
                    retryState.close(e);
                    throw e;
                }
                long delayMillis = retryState.nextDelay();
                try {
                    if (this.eventPublisher != null) {
                        try {
                            this.eventPublisher.publishEvent((Object)new RetryEvent(context, retryState, e));
                        }
                        catch (Exception e1) {
                            LOG.error("Error occurred publishing RetryEvent: " + e1.getMessage(), (Throwable)e1);
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Retrying execution for method [{}] after delay of {}ms for exception: {}", new Object[]{context, delayMillis, e.getMessage()});
                    }
                    Thread.sleep(delayMillis);
                }
                catch (InterruptedException e1) {
                    throw e;
                }
            }
        }
    }

    private Function retryFlowable(MethodInvocationContext<Object, Object> context, MutableRetryState retryState, Flowable observable) {
        return throwable -> {
            Throwable exception = (Throwable)throwable;
            if (retryState.canRetry(exception)) {
                Flowable retryObservable = observable.onErrorResumeNext(this.retryFlowable(context, retryState, observable));
                long delay = retryState.nextDelay();
                if (this.eventPublisher != null) {
                    try {
                        this.eventPublisher.publishEvent((Object)new RetryEvent(context, retryState, exception));
                    }
                    catch (Exception e1) {
                        LOG.error("Error occurred publishing RetryEvent: " + e1.getMessage(), (Throwable)e1);
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Retrying execution for method [{}] after delay of {}ms for exception: {}", new Object[]{context, delay, exception.getMessage()});
                }
                return retryObservable.delaySubscription(delay, TimeUnit.MILLISECONDS);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot retry anymore. Rethrowing original exception for method: {}", (Object)context);
            }
            retryState.close(exception);
            return Flowable.error((Throwable)exception);
        };
    }
}

