/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.runtime;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.DefaultApplicationContextBuilder;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.core.cli.CommandLine;
import io.micronaut.core.naming.Described;
import io.micronaut.runtime.EmbeddedApplication;
import io.micronaut.runtime.context.env.CommandLinePropertySource;
import io.micronaut.runtime.exceptions.ApplicationStartupException;
import io.micronaut.runtime.server.EmbeddedServer;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Micronaut
extends DefaultApplicationContextBuilder
implements ApplicationContextBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(Micronaut.class);
    private String[] args = new String[0];
    private Map<Class<? extends Throwable>, Function<Throwable, Integer>> exitHandlers = new LinkedHashMap<Class<? extends Throwable>, Function<Throwable, Integer>>();

    protected Micronaut() {
    }

    public ApplicationContext start() {
        CommandLine commandLine = CommandLine.parse((String[])this.args);
        this.propertySources(new PropertySource[]{new CommandLinePropertySource(commandLine)});
        ApplicationContext applicationContext = super.build();
        try {
            long start = System.currentTimeMillis();
            applicationContext.start();
            Optional embeddedContainerBean = applicationContext.findBean(EmbeddedApplication.class);
            embeddedContainerBean.ifPresent(embeddedApplication -> {
                block13: {
                    try {
                        long took;
                        long end;
                        embeddedApplication.start();
                        boolean keepAlive = false;
                        if (embeddedApplication instanceof Described) {
                            if (LOG.isInfoEnabled()) {
                                end = System.currentTimeMillis();
                                took = end - start;
                                String desc = ((Described)embeddedApplication).getDescription();
                                LOG.info("Startup completed in {}ms. Server Running: {}", (Object)took, (Object)desc);
                            }
                            keepAlive = embeddedApplication.isServer();
                        } else if (embeddedApplication instanceof EmbeddedServer) {
                            if (LOG.isInfoEnabled()) {
                                end = System.currentTimeMillis();
                                took = end - start;
                                URL url = ((EmbeddedServer)embeddedApplication).getURL();
                                LOG.info("Startup completed in {}ms. Server Running: {}", (Object)took, (Object)url);
                            }
                        } else {
                            if (LOG.isInfoEnabled()) {
                                end = System.currentTimeMillis();
                                took = end - start;
                                LOG.info("Startup completed in {}ms.", (Object)took);
                            }
                            keepAlive = embeddedApplication.isServer();
                        }
                        Thread mainThread = Thread.currentThread();
                        boolean finalKeepAlive = keepAlive;
                        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                            if (LOG.isInfoEnabled()) {
                                LOG.info("Embedded Application shutting down");
                            }
                            embeddedApplication.stop();
                            if (finalKeepAlive) {
                                mainThread.interrupt();
                            }
                        }));
                        if (!keepAlive) break block13;
                        try {
                            while (embeddedApplication.isRunning()) {
                                Thread.sleep(1000L);
                            }
                            if (LOG.isInfoEnabled()) {
                                LOG.info("Embedded Application shutting down");
                            }
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    catch (Throwable e) {
                        this.handleStartupException(applicationContext.getEnvironment(), e);
                    }
                }
            });
            if (LOG.isInfoEnabled() && !embeddedContainerBean.isPresent()) {
                LOG.info("No embedded container found. Running as CLI application");
            }
            return applicationContext;
        }
        catch (Throwable e) {
            this.handleStartupException(applicationContext.getEnvironment(), e);
            return null;
        }
    }

    public Micronaut include(String ... configurations) {
        return (Micronaut)super.include(configurations);
    }

    public Micronaut exclude(String ... configurations) {
        return (Micronaut)super.exclude(configurations);
    }

    public Micronaut classes(Class ... classes) {
        if (classes != null) {
            for (Class aClass : classes) {
                this.packages(aClass.getPackage().getName());
            }
        }
        return this;
    }

    public Micronaut properties(@Nullable Map<String, Object> properties) {
        return (Micronaut)super.properties(properties);
    }

    public Micronaut singletons(Object ... beans) {
        return (Micronaut)super.singletons(beans);
    }

    public Micronaut propertySources(PropertySource ... propertySources) {
        return (Micronaut)super.propertySources(propertySources);
    }

    public Micronaut mainClass(Class mainClass) {
        return (Micronaut)super.mainClass(mainClass);
    }

    public Micronaut classLoader(ClassLoader classLoader) {
        return (Micronaut)super.classLoader(classLoader);
    }

    public Micronaut args(String ... args) {
        if (args != null) {
            this.args = args;
        }
        return this;
    }

    public Micronaut environments(String ... environments) {
        return (Micronaut)super.environments(environments);
    }

    public Micronaut packages(String ... packages) {
        return (Micronaut)super.packages(packages);
    }

    public <T extends Throwable> Micronaut mapError(Class<T> exception, Function<T, Integer> mapper) {
        this.exitHandlers.put(exception, mapper);
        return this;
    }

    public static Micronaut build(String ... args) {
        return new Micronaut().args(args);
    }

    public static ApplicationContext run(String ... args) {
        return Micronaut.run(new Class[0], args);
    }

    public static ApplicationContext run(Class cls, String ... args) {
        return Micronaut.run(new Class[]{cls}, args);
    }

    public static ApplicationContext run(Class[] classes, String ... args) {
        return new Micronaut().classes(classes).args(args).start();
    }

    protected void handleStartupException(Environment environment, Throwable exception) {
        Function exitCodeMapper = this.exitHandlers.computeIfAbsent(exception.getClass(), exceptionType -> throwable -> 1);
        Integer code = (Integer)exitCodeMapper.apply(exception);
        if (code > 0 && !environment.getActiveNames().contains("test")) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Error starting Micronaut server: " + exception.getMessage(), exception);
            }
            System.exit(code);
        }
        throw new ApplicationStartupException("Error starting Micronaut server: " + exception.getMessage(), exception);
    }
}

