/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rxjava2.http.client;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.StreamingHttpClient;
import io.micronaut.rxjava2.http.client.BridgedRxHttpClient;
import io.micronaut.rxjava2.http.client.RxStreamingHttpClient;
import io.reactivex.Flowable;
import java.util.Map;
import org.reactivestreams.Publisher;

@Internal
class BridgedRxStreamingHttpClient
extends BridgedRxHttpClient
implements RxStreamingHttpClient {
    private final StreamingHttpClient streamingHttpClient;

    BridgedRxStreamingHttpClient(StreamingHttpClient streamingHttpClient) {
        super((HttpClient)streamingHttpClient);
        this.streamingHttpClient = streamingHttpClient;
    }

    @Override
    public <I> Flowable<ByteBuffer<?>> dataStream(@NonNull HttpRequest<I> request) {
        return Flowable.fromPublisher((Publisher)this.streamingHttpClient.dataStream(request));
    }

    public <I> Publisher<ByteBuffer<?>> dataStream(@NonNull HttpRequest<I> request, @NonNull Argument<?> errorType) {
        return Flowable.fromPublisher((Publisher)this.streamingHttpClient.dataStream(request, errorType));
    }

    @Override
    public <I> Flowable<HttpResponse<ByteBuffer<?>>> exchangeStream(@NonNull HttpRequest<I> request) {
        return Flowable.fromPublisher((Publisher)this.streamingHttpClient.exchangeStream(request));
    }

    public <I> Publisher<HttpResponse<ByteBuffer<?>>> exchangeStream(@NonNull HttpRequest<I> request, @NonNull Argument<?> errorType) {
        return Flowable.fromPublisher((Publisher)this.streamingHttpClient.exchangeStream(request, errorType));
    }

    @Override
    public <I> Publisher<Map<String, Object>> jsonStream(@NonNull HttpRequest<I> request) {
        return Flowable.fromPublisher((Publisher)this.streamingHttpClient.jsonStream(request));
    }

    @Override
    public <I, O> Flowable<O> jsonStream(@NonNull HttpRequest<I> request, @NonNull Argument<O> type) {
        return Flowable.fromPublisher((Publisher)this.streamingHttpClient.jsonStream(request, type));
    }

    public <I, O> Publisher<O> jsonStream(@NonNull HttpRequest<I> request, @NonNull Argument<O> type, @NonNull Argument<?> errorType) {
        return Flowable.fromPublisher((Publisher)this.streamingHttpClient.jsonStream(request, type, errorType));
    }

    @Override
    public <I, O> Flowable<O> jsonStream(@NonNull HttpRequest<I> request, @NonNull Class<O> type) {
        return Flowable.fromPublisher((Publisher)this.streamingHttpClient.jsonStream(request, type));
    }
}

