/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rxjava2.http.client;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.StreamingHttpClient;
import io.micronaut.rxjava2.http.client.BridgedRxStreamingHttpClient;
import io.micronaut.rxjava2.http.client.RxHttpClient;
import io.reactivex.Flowable;
import java.net.URL;
import java.util.Map;
import org.reactivestreams.Publisher;

public interface RxStreamingHttpClient
extends StreamingHttpClient,
RxHttpClient {
    public <I> Flowable<ByteBuffer<?>> dataStream(@NonNull HttpRequest<I> var1);

    public <I> Flowable<HttpResponse<ByteBuffer<?>>> exchangeStream(@NonNull HttpRequest<I> var1);

    public <I> Publisher<Map<String, Object>> jsonStream(@NonNull HttpRequest<I> var1);

    public <I, O> Flowable<O> jsonStream(@NonNull HttpRequest<I> var1, @NonNull Argument<O> var2);

    default public <I, O> Flowable<O> jsonStream(@NonNull HttpRequest<I> request, @NonNull Class<O> type) {
        return (Flowable)super.jsonStream(request, type);
    }

    public static RxStreamingHttpClient create(@Nullable URL url) {
        return new BridgedRxStreamingHttpClient(StreamingHttpClient.create((URL)url));
    }

    public static RxStreamingHttpClient create(@Nullable URL url, @NonNull HttpClientConfiguration configuration) {
        return new BridgedRxStreamingHttpClient(StreamingHttpClient.create((URL)url, (HttpClientConfiguration)configuration));
    }
}

