/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rxjava2.http.client.sse;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.sse.SseClient;
import io.micronaut.http.sse.Event;
import io.micronaut.rxjava2.http.client.sse.BridgedRxSseClient;
import io.reactivex.Flowable;
import java.net.URL;

public interface RxSseClient
extends SseClient {
    public <I> Flowable<Event<ByteBuffer<?>>> eventStream(@NonNull HttpRequest<I> var1);

    public <I, B> Flowable<Event<B>> eventStream(@NonNull HttpRequest<I> var1, @NonNull Argument<B> var2);

    default public <I, B> Flowable<Event<B>> eventStream(@NonNull HttpRequest<I> request, @NonNull Class<B> eventType) {
        return (Flowable)super.eventStream(request, eventType);
    }

    default public <B> Flowable<Event<B>> eventStream(@NonNull String uri, @NonNull Class<B> eventType) {
        return (Flowable)super.eventStream(uri, eventType);
    }

    default public <B> Flowable<Event<B>> eventStream(@NonNull String uri, @NonNull Argument<B> eventType) {
        return (Flowable)super.eventStream(uri, eventType);
    }

    public static RxSseClient create(@Nullable URL url) {
        return new BridgedRxSseClient(SseClient.create((URL)url));
    }

    public static RxSseClient create(@Nullable URL url, @NonNull HttpClientConfiguration configuration) {
        return new BridgedRxSseClient(SseClient.create((URL)url, (HttpClientConfiguration)configuration));
    }
}

