/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rxjava2.http.client;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.StreamingHttpClient;
import io.micronaut.rxjava2.http.client.BridgedRxHttpClient;
import io.reactivex.Flowable;
import java.net.URL;
import org.reactivestreams.Publisher;

public interface RxHttpClient
extends HttpClient {
    default public <I, O> Flowable<HttpResponse<O>> exchange(@NonNull HttpRequest<I> request, @NonNull Argument<O> bodyType) {
        return Flowable.fromPublisher((Publisher)super.exchange(request, bodyType));
    }

    public <I, O, E> Flowable<HttpResponse<O>> exchange(@NonNull HttpRequest<I> var1, @NonNull Argument<O> var2, @NonNull Argument<E> var3);

    default public <I, O, E> Flowable<O> retrieve(@NonNull HttpRequest<I> request, @NonNull Argument<O> bodyType, @NonNull Argument<E> errorType) {
        return Flowable.fromPublisher((Publisher)super.retrieve(request, bodyType, errorType));
    }

    default public <I> Flowable<HttpResponse<ByteBuffer>> exchange(@NonNull HttpRequest<I> request) {
        return Flowable.fromPublisher((Publisher)super.exchange(request));
    }

    default public Flowable<HttpResponse<ByteBuffer>> exchange(@NonNull String uri) {
        return Flowable.fromPublisher((Publisher)super.exchange(uri));
    }

    default public <O> Flowable<HttpResponse<O>> exchange(@NonNull String uri, @NonNull Class<O> bodyType) {
        return Flowable.fromPublisher((Publisher)super.exchange(uri, bodyType));
    }

    default public <I, O> Flowable<HttpResponse<O>> exchange(@NonNull HttpRequest<I> request, @NonNull Class<O> bodyType) {
        return Flowable.fromPublisher((Publisher)super.exchange(request, bodyType));
    }

    default public <I, O> Flowable<O> retrieve(@NonNull HttpRequest<I> request, @NonNull Argument<O> bodyType) {
        return Flowable.fromPublisher((Publisher)super.retrieve(request, bodyType));
    }

    default public <I, O> Flowable<O> retrieve(@NonNull HttpRequest<I> request, @NonNull Class<O> bodyType) {
        return this.retrieve(request, (Argument<O>)Argument.of(bodyType), (Argument<E>)DEFAULT_ERROR_TYPE);
    }

    default public <I> Flowable<String> retrieve(@NonNull HttpRequest<I> request) {
        return this.retrieve(request, (Argument<O>)Argument.STRING, (Argument<E>)DEFAULT_ERROR_TYPE);
    }

    default public Flowable<String> retrieve(@NonNull String uri) {
        return this.retrieve((HttpRequest<I>)((HttpRequest)HttpRequest.GET((String)uri)), (Argument<O>)Argument.STRING, (Argument<E>)DEFAULT_ERROR_TYPE);
    }

    public static RxHttpClient create(@Nullable URL url) {
        return new BridgedRxHttpClient(HttpClient.create((URL)url));
    }

    public static RxHttpClient create(@Nullable URL url, @NonNull HttpClientConfiguration configuration) {
        return new BridgedRxHttpClient((HttpClient)StreamingHttpClient.create((URL)url, (HttpClientConfiguration)configuration));
    }
}

