/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rxjava2.http.client.websockets;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.rxjava2.http.client.websockets.RxWebSocketClient;
import io.micronaut.websocket.WebSocketClient;
import io.reactivex.Flowable;
import java.util.Map;
import org.reactivestreams.Publisher;

@Internal
class BridgedRxWebSocketClient
implements RxWebSocketClient {
    private final WebSocketClient webSocketClient;

    BridgedRxWebSocketClient(WebSocketClient webSocketClient) {
        this.webSocketClient = webSocketClient;
    }

    @Override
    public <T extends AutoCloseable> Flowable<T> connect(Class<T> clientEndpointType, MutableHttpRequest<?> request) {
        return Flowable.fromPublisher((Publisher)this.webSocketClient.connect(clientEndpointType, request));
    }

    @Override
    public <T extends AutoCloseable> Flowable<T> connect(Class<T> clientEndpointType, Map<String, Object> parameters) {
        return Flowable.fromPublisher((Publisher)this.webSocketClient.connect(clientEndpointType, parameters));
    }

    public void close() {
        this.webSocketClient.close();
    }
}

