/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rxjava2.server.upload.binders;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.server.netty.HttpContentProcessorResolver;
import io.micronaut.rxjava2.server.upload.binders.MaybeBodyBinder;
import io.micronaut.rxjava2.server.upload.binders.ObservableBodyBinder;
import io.micronaut.rxjava2.server.upload.binders.SingleBodyBinder;
import io.reactivex.Flowable;
import jakarta.inject.Singleton;

@Singleton
@Internal
@Requires(classes={Flowable.class})
class RxJava2NettyBinderRegistrar
implements BeanCreatedEventListener<RequestBinderRegistry> {
    private final ConversionService<?> conversionService;
    private final HttpContentProcessorResolver httpContentProcessorResolver;

    RxJava2NettyBinderRegistrar(@Nullable ConversionService<?> conversionService, HttpContentProcessorResolver httpContentProcessorResolver) {
        this.conversionService = conversionService == null ? ConversionService.SHARED : conversionService;
        this.httpContentProcessorResolver = httpContentProcessorResolver;
    }

    public RequestBinderRegistry onCreated(BeanCreatedEvent<RequestBinderRegistry> event) {
        RequestBinderRegistry registry = (RequestBinderRegistry)event.getBean();
        registry.addRequestArgumentBinder((ArgumentBinder)new MaybeBodyBinder(this.conversionService, this.httpContentProcessorResolver));
        registry.addRequestArgumentBinder((ArgumentBinder)new ObservableBodyBinder(this.conversionService, this.httpContentProcessorResolver));
        registry.addRequestArgumentBinder((ArgumentBinder)new SingleBodyBinder(this.conversionService, this.httpContentProcessorResolver));
        return registry;
    }
}

