/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rxjava2.instrument;

import io.micronaut.core.annotation.Internal;
import io.micronaut.rxjava2.instrument.RxInstrumentedComponent;
import io.micronaut.rxjava2.instrument.RxInstrumenterFactory;
import io.micronaut.scheduling.instrument.Instrumentation;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Internal
class RxInstrumentedSubscriber<T>
implements Subscriber<T>,
RxInstrumentedComponent {
    private final Subscriber<T> source;
    private final InvocationInstrumenter instrumenter;

    RxInstrumentedSubscriber(Subscriber<T> source, RxInstrumenterFactory instrumenterFactory) {
        this.source = source;
        this.instrumenter = instrumenterFactory.create();
    }

    public void onSubscribe(Subscription s) {
        try (Instrumentation ignored = this.instrumenter.newInstrumentation();){
            this.source.onSubscribe(s);
        }
    }

    public void onNext(T t) {
        try (Instrumentation ignored = this.instrumenter.newInstrumentation();){
            this.source.onNext(t);
        }
    }

    public void onError(Throwable t) {
        try (Instrumentation ignored = this.instrumenter.newInstrumentation();){
            this.source.onError(t);
        }
    }

    public void onComplete() {
        try (Instrumentation ignored = this.instrumenter.newInstrumentation();){
            this.source.onComplete();
        }
    }
}

