/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rxjava2.instrument;

import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.rxjava2.instrument.RxInstrumentedWrappers;
import io.micronaut.rxjava2.instrument.RxInstrumenterFactory;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.flowables.ConnectableFlowable;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Function;
import io.reactivex.observables.ConnectableObservable;
import io.reactivex.parallel.ParallelFlowable;
import io.reactivex.plugins.RxJavaPlugins;
import jakarta.inject.Singleton;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.reactivestreams.Subscriber;

@Singleton
@Context
@Requires(classes={Flowable.class})
@Internal
@TypeHint(value={Completable.class, Single.class, Flowable.class, Maybe.class, Observable.class})
class RxJava2Instrumentation
implements AutoCloseable {
    private final RxInstrumenterFactory instrumenterFactory;
    private BiFunction<? super Single, ? super SingleObserver, ? extends SingleObserver> oldSingleSubscribeHook;
    private BiFunction<? super Completable, ? super CompletableObserver, ? extends CompletableObserver> oldCompletableSubscribeHook;
    private BiFunction<? super Flowable, ? super Subscriber, ? extends Subscriber> oldFlowableSubscribeHook;
    private BiFunction<? super Maybe, ? super MaybeObserver, ? extends MaybeObserver> oldMaybeSubscribeHook;
    private BiFunction<? super Observable, ? super Observer, ? extends Observer> oldObservableSubscribeHook;
    private Function<? super Completable, ? extends Completable> oldCompletableHook;
    private Function<? super Maybe, ? extends Maybe> oldMaybeHook;
    private Function<? super Single, ? extends Single> oldSingleHook;
    private Function<? super Observable, ? extends Observable> oldObservableHook;
    private Function<? super Flowable, ? extends Flowable> oldFlowableHook;
    private Function<? super ConnectableFlowable, ? extends ConnectableFlowable> oldConnectableFlowableHook;
    private Function<? super ConnectableObservable, ? extends ConnectableObservable> oldConnectableObservableHook;
    private Function<? super ParallelFlowable, ? extends ParallelFlowable> oldParallelFlowableHook;

    public RxJava2Instrumentation(RxInstrumenterFactory instrumenterFactory) {
        this.instrumenterFactory = instrumenterFactory;
    }

    @PostConstruct
    void init() {
        if (this.instrumenterFactory.hasInstrumenters()) {
            this.oldSingleSubscribeHook = RxJavaPlugins.getOnSingleSubscribe();
            this.oldCompletableSubscribeHook = RxJavaPlugins.getOnCompletableSubscribe();
            this.oldFlowableSubscribeHook = RxJavaPlugins.getOnFlowableSubscribe();
            this.oldMaybeSubscribeHook = RxJavaPlugins.getOnMaybeSubscribe();
            this.oldObservableSubscribeHook = RxJavaPlugins.getOnObservableSubscribe();
            this.oldCompletableHook = RxJavaPlugins.getOnCompletableAssembly();
            this.oldMaybeHook = RxJavaPlugins.getOnMaybeAssembly();
            this.oldSingleHook = RxJavaPlugins.getOnSingleAssembly();
            this.oldObservableHook = RxJavaPlugins.getOnObservableAssembly();
            this.oldFlowableHook = RxJavaPlugins.getOnFlowableAssembly();
            this.oldConnectableFlowableHook = RxJavaPlugins.getOnConnectableFlowableAssembly();
            this.oldConnectableObservableHook = RxJavaPlugins.getOnConnectableObservableAssembly();
            this.oldParallelFlowableHook = RxJavaPlugins.getOnParallelAssembly();
            RxJavaPlugins.setOnSingleSubscribe((single, singleObserver) -> {
                SingleObserver wrapped = RxInstrumentedWrappers.wrap(singleObserver, this.instrumenterFactory);
                if (this.oldSingleSubscribeHook != null) {
                    return (SingleObserver)this.oldSingleSubscribeHook.apply(single, wrapped);
                }
                return wrapped;
            });
            RxJavaPlugins.setOnCompletableSubscribe((completable, observer) -> {
                CompletableObserver wrapped = RxInstrumentedWrappers.wrap(observer, this.instrumenterFactory);
                if (this.oldCompletableSubscribeHook != null) {
                    return (CompletableObserver)this.oldCompletableSubscribeHook.apply(completable, (Object)wrapped);
                }
                return wrapped;
            });
            RxJavaPlugins.setOnFlowableSubscribe((flowable, subscriber) -> {
                Subscriber wrapped = RxInstrumentedWrappers.wrap(subscriber, this.instrumenterFactory);
                if (this.oldFlowableSubscribeHook != null) {
                    return (Subscriber)this.oldFlowableSubscribeHook.apply(flowable, wrapped);
                }
                return wrapped;
            });
            RxJavaPlugins.setOnMaybeSubscribe((maybe, maybeObserver) -> {
                MaybeObserver wrapped = RxInstrumentedWrappers.wrap(maybeObserver, this.instrumenterFactory);
                if (this.oldMaybeSubscribeHook != null) {
                    return (MaybeObserver)this.oldMaybeSubscribeHook.apply(maybe, wrapped);
                }
                return wrapped;
            });
            RxJavaPlugins.setOnObservableSubscribe((observable, observer) -> {
                Observer wrapped = RxInstrumentedWrappers.wrap(observer, this.instrumenterFactory);
                if (this.oldObservableSubscribeHook != null) {
                    return (Observer)this.oldObservableSubscribeHook.apply(observable, wrapped);
                }
                return wrapped;
            });
            RxJavaPlugins.setOnCompletableAssembly(completable -> {
                Completable wrapped = RxInstrumentedWrappers.wrap(completable, this.instrumenterFactory);
                if (this.oldCompletableHook != null) {
                    return (Completable)this.oldCompletableHook.apply((Object)wrapped);
                }
                return wrapped;
            });
            RxJavaPlugins.setOnMaybeAssembly(maybe -> {
                Maybe wrapped = RxInstrumentedWrappers.wrap(maybe, this.instrumenterFactory);
                if (this.oldMaybeHook != null) {
                    return (Maybe)this.oldMaybeHook.apply(wrapped);
                }
                return wrapped;
            });
            RxJavaPlugins.setOnSingleAssembly(single -> {
                Single wrapped = RxInstrumentedWrappers.wrap(single, this.instrumenterFactory);
                if (this.oldSingleHook != null) {
                    return (Single)this.oldSingleHook.apply(wrapped);
                }
                return wrapped;
            });
            RxJavaPlugins.setOnObservableAssembly(observable -> {
                Observable wrapped = RxInstrumentedWrappers.wrap(observable, this.instrumenterFactory);
                if (this.oldObservableHook != null) {
                    return (Observable)this.oldObservableHook.apply(wrapped);
                }
                return wrapped;
            });
            RxJavaPlugins.setOnFlowableAssembly(flowable -> {
                Flowable wrapped = RxInstrumentedWrappers.wrap(flowable, this.instrumenterFactory);
                if (this.oldFlowableHook != null) {
                    return (Flowable)this.oldFlowableHook.apply(wrapped);
                }
                return wrapped;
            });
            RxJavaPlugins.setOnConnectableFlowableAssembly(connectableFlowable -> {
                ConnectableFlowable wrapped = RxInstrumentedWrappers.wrap(connectableFlowable, this.instrumenterFactory);
                if (this.oldConnectableFlowableHook != null) {
                    return (ConnectableFlowable)this.oldConnectableFlowableHook.apply(wrapped);
                }
                return wrapped;
            });
            RxJavaPlugins.setOnConnectableObservableAssembly(connectableObservable -> {
                ConnectableObservable wrapped = RxInstrumentedWrappers.wrap(connectableObservable, this.instrumenterFactory);
                if (this.oldConnectableObservableHook != null) {
                    return (ConnectableObservable)this.oldConnectableObservableHook.apply(wrapped);
                }
                return wrapped;
            });
            RxJavaPlugins.setOnParallelAssembly(parallelFlowable -> {
                ParallelFlowable wrapped = RxInstrumentedWrappers.wrap(parallelFlowable, this.instrumenterFactory);
                if (this.oldParallelFlowableHook != null) {
                    return (ParallelFlowable)this.oldParallelFlowableHook.apply(wrapped);
                }
                return wrapped;
            });
        }
    }

    @Override
    @PreDestroy
    public void close() {
        if (this.instrumenterFactory.hasInstrumenters()) {
            try {
                RxJavaPlugins.setOnSingleSubscribe(this.oldSingleSubscribeHook);
                RxJavaPlugins.setOnCompletableSubscribe(this.oldCompletableSubscribeHook);
                RxJavaPlugins.setOnFlowableSubscribe(this.oldFlowableSubscribeHook);
                RxJavaPlugins.setOnMaybeSubscribe(this.oldMaybeSubscribeHook);
                RxJavaPlugins.setOnObservableSubscribe(this.oldObservableSubscribeHook);
                RxJavaPlugins.setOnCompletableAssembly(this.oldCompletableHook);
                RxJavaPlugins.setOnSingleAssembly(this.oldSingleHook);
                RxJavaPlugins.setOnMaybeAssembly(this.oldMaybeHook);
                RxJavaPlugins.setOnObservableAssembly(this.oldObservableHook);
                RxJavaPlugins.setOnFlowableAssembly(this.oldFlowableHook);
                RxJavaPlugins.setOnConnectableObservableAssembly(this.oldConnectableObservableHook);
                RxJavaPlugins.setOnConnectableFlowableAssembly(this.oldConnectableFlowableHook);
                RxJavaPlugins.setOnParallelAssembly(this.oldParallelFlowableHook);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

