/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rxjava2.instrument;

import io.micronaut.core.annotation.Internal;
import io.micronaut.rxjava2.instrument.RxInstrumentedComponent;
import io.micronaut.rxjava2.instrument.RxInstrumenterFactory;
import io.micronaut.scheduling.instrument.Instrumentation;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposable;

@Internal
final class RxInstrumentedCompletableObserver
implements CompletableObserver,
RxInstrumentedComponent {
    private final CompletableObserver source;
    private final InvocationInstrumenter instrumenter;

    RxInstrumentedCompletableObserver(CompletableObserver source, RxInstrumenterFactory instrumenterFactory) {
        this.source = source;
        this.instrumenter = instrumenterFactory.create();
    }

    public void onSubscribe(Disposable d) {
        try (Instrumentation ignored = this.instrumenter.newInstrumentation();){
            this.source.onSubscribe(d);
        }
    }

    public void onError(Throwable t) {
        try (Instrumentation ignored = this.instrumenter.newInstrumentation();){
            this.source.onError(t);
        }
    }

    public void onComplete() {
        try (Instrumentation ignored = this.instrumenter.newInstrumentation();){
            this.source.onComplete();
        }
    }
}

