/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rxjava2.instrument;

import io.micronaut.core.annotation.Internal;
import io.micronaut.rxjava2.instrument.RxInstrumentedComponent;
import io.micronaut.scheduling.instrument.Instrumentation;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.reactivex.disposables.Disposable;
import io.reactivex.flowables.ConnectableFlowable;
import io.reactivex.functions.Consumer;
import org.reactivestreams.Subscriber;

@Internal
final class RxInstrumentedConnectableFlowable<T>
extends ConnectableFlowable<T>
implements RxInstrumentedComponent {
    private final ConnectableFlowable<T> source;
    private final InvocationInstrumenter instrumenter;

    RxInstrumentedConnectableFlowable(ConnectableFlowable<T> source, InvocationInstrumenter instrumenter) {
        this.source = source;
        this.instrumenter = instrumenter;
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        try (Instrumentation ignored = this.instrumenter.newInstrumentation();){
            this.source.subscribe(s);
        }
    }

    public void connect(Consumer<? super Disposable> connection) {
        try (Instrumentation ignored = this.instrumenter.newInstrumentation();){
            this.source.connect(connection);
        }
    }
}

