/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rxjava2.instrument;

import io.micronaut.core.annotation.Internal;
import io.micronaut.rxjava2.instrument.RxInstrumentedComponent;
import io.micronaut.scheduling.instrument.Instrumentation;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.observables.ConnectableObservable;

@Internal
final class RxInstrumentedConnectableObservable<T>
extends ConnectableObservable<T>
implements RxInstrumentedComponent {
    private final ConnectableObservable<T> source;
    private final InvocationInstrumenter instrumenter;

    RxInstrumentedConnectableObservable(ConnectableObservable<T> source, InvocationInstrumenter instrumenter) {
        this.source = source;
        this.instrumenter = instrumenter;
    }

    protected void subscribeActual(Observer<? super T> o) {
        try (Instrumentation ignored = this.instrumenter.newInstrumentation();){
            this.source.subscribe(o);
        }
    }

    public void connect(Consumer<? super Disposable> connection) {
        try (Instrumentation ignored = this.instrumenter.newInstrumentation();){
            this.source.connect(connection);
        }
    }
}

