/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rxjava2.instrument;

import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.propagation.PropagatedContext;
import io.reactivex.functions.Function;
import io.reactivex.plugins.RxJavaPlugins;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;

@Requires(classes={RxJavaPlugins.class, PropagatedContext.class})
@Context
@Internal
final class RxJava2Instrumentation {
    private Function<? super Runnable, ? extends Runnable> scheduleHandler;

    RxJava2Instrumentation() {
    }

    @PostConstruct
    void init() {
        this.scheduleHandler = RxJavaPlugins.getScheduleHandler();
        RxJavaPlugins.setScheduleHandler(runnable -> {
            if (this.scheduleHandler != null) {
                runnable = (Runnable)this.scheduleHandler.apply(runnable);
            }
            return PropagatedContext.wrapCurrent((Runnable)runnable);
        });
    }

    @PreDestroy
    void removeInstrumentation() {
        RxJavaPlugins.setScheduleHandler(this.scheduleHandler);
    }
}

