/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rxjava3.http.client;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.client.BlockingHttpClient;
import io.micronaut.http.client.HttpClient;
import io.micronaut.rxjava3.http.client.Rx3HttpClient;
import io.reactivex.rxjava3.core.Flowable;
import org.reactivestreams.Publisher;

@Internal
class BridgedRx3HttpClient
implements Rx3HttpClient {
    private final HttpClient httpClient;

    BridgedRx3HttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public BlockingHttpClient toBlocking() {
        return this.httpClient.toBlocking();
    }

    @Override
    public <I, O, E> Flowable<HttpResponse<O>> exchange(@NonNull HttpRequest<I> request, @NonNull Argument<O> bodyType, @NonNull Argument<E> errorType) {
        return Flowable.fromPublisher((Publisher)this.httpClient.exchange(request, bodyType, errorType));
    }

    @Override
    public <I, O> Flowable<HttpResponse<O>> exchange(@NonNull HttpRequest<I> request, @NonNull Argument<O> bodyType) {
        return Flowable.fromPublisher((Publisher)this.httpClient.exchange(request, bodyType));
    }

    @Override
    public <I, O, E> Flowable<O> retrieve(@NonNull HttpRequest<I> request, @NonNull Argument<O> bodyType, @NonNull Argument<E> errorType) {
        return Flowable.fromPublisher((Publisher)this.httpClient.retrieve(request, bodyType));
    }

    @Override
    public <I> Flowable<HttpResponse<ByteBuffer>> exchange(@NonNull HttpRequest<I> request) {
        return Flowable.fromPublisher((Publisher)this.httpClient.exchange(request));
    }

    @Override
    public Flowable<HttpResponse<ByteBuffer>> exchange(@NonNull String uri) {
        return Flowable.fromPublisher((Publisher)this.httpClient.exchange(uri));
    }

    @Override
    public <O> Flowable<HttpResponse<O>> exchange(@NonNull String uri, @NonNull Class<O> bodyType) {
        return Flowable.fromPublisher((Publisher)this.httpClient.exchange(uri, bodyType));
    }

    @Override
    public <I, O> Flowable<HttpResponse<O>> exchange(@NonNull HttpRequest<I> request, @NonNull Class<O> bodyType) {
        return Flowable.fromPublisher((Publisher)this.httpClient.exchange(request, bodyType));
    }

    @Override
    public <I, O> Flowable<O> retrieve(@NonNull HttpRequest<I> request, @NonNull Argument<O> bodyType) {
        return Flowable.fromPublisher((Publisher)this.httpClient.retrieve(request, bodyType));
    }

    @Override
    public <I, O> Flowable<O> retrieve(@NonNull HttpRequest<I> request, @NonNull Class<O> bodyType) {
        return Flowable.fromPublisher((Publisher)this.httpClient.retrieve(request, bodyType));
    }

    @Override
    public <I> Flowable<String> retrieve(@NonNull HttpRequest<I> request) {
        return Flowable.fromPublisher((Publisher)this.httpClient.retrieve(request));
    }

    @Override
    public Flowable<String> retrieve(@NonNull String uri) {
        return Flowable.fromPublisher((Publisher)this.httpClient.retrieve(uri));
    }

    public boolean isRunning() {
        return this.httpClient.isRunning();
    }

    public void close() {
        this.httpClient.close();
    }

    @NonNull
    public HttpClient start() {
        this.httpClient.start();
        return this;
    }

    @NonNull
    public HttpClient stop() {
        this.httpClient.stop();
        return this;
    }
}

