/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rxjava3.http.client;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.StreamingHttpClient;
import io.micronaut.rxjava3.http.client.BridgedRx3HttpClient;
import io.micronaut.rxjava3.http.client.Rx3StreamingHttpClient;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Map;
import org.reactivestreams.Publisher;

@Internal
class BridgedRx3StreamingHttpClient
extends BridgedRx3HttpClient
implements Rx3StreamingHttpClient {
    private final StreamingHttpClient streamingHttpClient;

    BridgedRx3StreamingHttpClient(StreamingHttpClient streamingHttpClient) {
        super((HttpClient)streamingHttpClient);
        this.streamingHttpClient = streamingHttpClient;
    }

    @Override
    public <I> Flowable<ByteBuffer<?>> dataStream(@NonNull HttpRequest<I> request) {
        return Flowable.fromPublisher((Publisher)this.streamingHttpClient.dataStream(request));
    }

    public <I> Publisher<ByteBuffer<?>> dataStream(@NonNull HttpRequest<I> request, @NonNull Argument<?> errorType) {
        return Flowable.fromPublisher((Publisher)this.streamingHttpClient.dataStream(request, errorType));
    }

    @Override
    public <I> Flowable<HttpResponse<ByteBuffer<?>>> exchangeStream(@NonNull HttpRequest<I> request) {
        return Flowable.fromPublisher((Publisher)this.streamingHttpClient.exchangeStream(request));
    }

    public <I> Publisher<HttpResponse<ByteBuffer<?>>> exchangeStream(@NonNull HttpRequest<I> request, @NonNull Argument<?> errorType) {
        return Flowable.fromPublisher((Publisher)this.streamingHttpClient.exchangeStream(request, errorType));
    }

    @Override
    public <I> Flowable<Map<String, Object>> jsonStream(@NonNull HttpRequest<I> request) {
        return Flowable.fromPublisher((Publisher)this.streamingHttpClient.jsonStream(request));
    }

    @Override
    public <I, O> Flowable<O> jsonStream(@NonNull HttpRequest<I> request, @NonNull Argument<O> type) {
        return Flowable.fromPublisher((Publisher)this.streamingHttpClient.jsonStream(request, type));
    }

    public <I, O> Publisher<O> jsonStream(@NonNull HttpRequest<I> request, @NonNull Argument<O> type, @NonNull Argument<?> errorType) {
        return Flowable.fromPublisher((Publisher)this.streamingHttpClient.jsonStream(request, type, errorType));
    }

    @Override
    public <I, O> Flowable<O> jsonStream(@NonNull HttpRequest<I> request, @NonNull Class<O> type) {
        return Flowable.fromPublisher((Publisher)this.streamingHttpClient.jsonStream(request, type));
    }
}

