/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rxjava3.http.client;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Indexed;
import io.micronaut.core.annotation.Internal;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.client.ReactiveClientResultTransformer;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import jakarta.inject.Singleton;

@Singleton
@Requires(classes={Maybe.class, ReactiveClientResultTransformer.class})
@Internal
@Indexed(value=ReactiveClientResultTransformer.class)
class RxJava3ClientResultTransformer
implements ReactiveClientResultTransformer {
    RxJava3ClientResultTransformer() {
    }

    public Object transform(Object publisherResult) {
        if (publisherResult instanceof Maybe) {
            Maybe maybe = (Maybe)publisherResult;
            return maybe.onErrorResumeNext(throwable -> {
                HttpClientResponseException responseException;
                if (throwable instanceof HttpClientResponseException && (responseException = (HttpClientResponseException)throwable).getStatus() == HttpStatus.NOT_FOUND) {
                    return Maybe.empty();
                }
                return Maybe.error((Throwable)throwable);
            });
        }
        if (publisherResult instanceof Flowable) {
            Flowable flux = (Flowable)publisherResult;
            return flux.onErrorResumeNext(throwable -> {
                HttpClientResponseException responseException;
                if (throwable instanceof HttpClientResponseException && (responseException = (HttpClientResponseException)throwable).getStatus() == HttpStatus.NOT_FOUND) {
                    return Flowable.empty();
                }
                return Flowable.error((Throwable)throwable);
            });
        }
        return publisherResult;
    }
}

