/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rxjava3.instrument;

import io.micronaut.core.annotation.Internal;
import io.micronaut.rxjava3.instrument.RxInstrumentedComponent;
import io.micronaut.rxjava3.instrument.RxInstrumenterFactory;
import io.micronaut.scheduling.instrument.Instrumentation;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.Disposable;

@Internal
final class RxInstrumentedSingleObserver<T>
implements SingleObserver<T>,
RxInstrumentedComponent {
    private final SingleObserver<T> source;
    private final InvocationInstrumenter instrumenter;

    RxInstrumentedSingleObserver(SingleObserver<T> source, RxInstrumenterFactory instrumenterFactory) {
        this.source = source;
        this.instrumenter = instrumenterFactory.create();
    }

    public void onSubscribe(Disposable d) {
        try (Instrumentation ignored = this.instrumenter.newInstrumentation();){
            this.source.onSubscribe(d);
        }
    }

    public void onError(Throwable t) {
        try (Instrumentation ignored = this.instrumenter.newInstrumentation();){
            this.source.onError(t);
        }
    }

    public void onSuccess(T value) {
        try (Instrumentation ignored = this.instrumenter.newInstrumentation();){
            this.source.onSuccess(value);
        }
    }
}

