/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rxjava3.instrument;

import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.micronaut.scheduling.instrument.ReactiveInvocationInstrumenterFactory;
import io.reactivex.rxjava3.core.Flowable;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;

@Singleton
@Context
@Requires(classes={Flowable.class})
@Internal
final class RxInstrumenterFactory {
    private final List<ReactiveInvocationInstrumenterFactory> reactiveInvocationInstrumenterFactories;

    public RxInstrumenterFactory(List<ReactiveInvocationInstrumenterFactory> reactiveInvocationInstrumenterFactories) {
        this.reactiveInvocationInstrumenterFactories = reactiveInvocationInstrumenterFactories;
    }

    public boolean hasInstrumenters() {
        return !this.reactiveInvocationInstrumenterFactories.isEmpty();
    }

    @Nullable
    public InvocationInstrumenter create() {
        List<InvocationInstrumenter> invocationInstrumenter = this.getReactiveInvocationInstrumenters();
        if (CollectionUtils.isNotEmpty(invocationInstrumenter)) {
            return InvocationInstrumenter.combine(invocationInstrumenter);
        }
        return null;
    }

    private List<InvocationInstrumenter> getReactiveInvocationInstrumenters() {
        ArrayList<InvocationInstrumenter> instrumenters = new ArrayList<InvocationInstrumenter>(this.reactiveInvocationInstrumenterFactories.size());
        for (ReactiveInvocationInstrumenterFactory instrumenterFactory : this.reactiveInvocationInstrumenterFactories) {
            InvocationInstrumenter instrumenter = instrumenterFactory.newReactiveInvocationInstrumenter();
            if (instrumenter == null) continue;
            instrumenters.add(instrumenter);
        }
        return instrumenters;
    }
}

