/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rxjava3.converters;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.convert.MutableConversionService;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.micronaut.core.propagation.PropagatedContext;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Single;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@TypeHint(value={Flowable.class, Maybe.class, Completable.class, Single.class, Observable.class})
public class RxJava3ConverterRegistrar
implements TypeConverterRegistrar {
    public void register(MutableConversionService conversionService) {
        conversionService.addConverter(Completable.class, Publisher.class, Completable::toFlowable);
        conversionService.addConverter(Completable.class, Single.class, completable -> completable.toSingleDefault(new Object()));
        conversionService.addConverter(Completable.class, Maybe.class, Completable::toMaybe);
        conversionService.addConverter(Completable.class, Observable.class, Completable::toObservable);
        conversionService.addConverter(Object.class, Completable.class, obj -> Completable.complete());
        conversionService.addConverter(Maybe.class, Publisher.class, Maybe::toFlowable);
        conversionService.addConverter(Maybe.class, Single.class, Maybe::toSingle);
        conversionService.addConverter(Maybe.class, Observable.class, Maybe::toObservable);
        conversionService.addConverter(Maybe.class, Completable.class, Completable::fromMaybe);
        conversionService.addConverter(Object.class, Maybe.class, Maybe::just);
        conversionService.addConverter(Observable.class, Publisher.class, observable -> observable.toFlowable(BackpressureStrategy.BUFFER));
        conversionService.addConverter(Observable.class, Single.class, Observable::firstOrError);
        conversionService.addConverter(Observable.class, Maybe.class, Observable::firstElement);
        conversionService.addConverter(Observable.class, Completable.class, Completable::fromObservable);
        conversionService.addConverter(Object.class, Observable.class, o -> {
            if (o instanceof Iterable) {
                return Observable.fromIterable((Iterable)((Iterable)o));
            }
            return Observable.just((Object)o);
        });
        conversionService.addConverter(Single.class, Publisher.class, Single::toFlowable);
        conversionService.addConverter(Single.class, Maybe.class, Single::toMaybe);
        conversionService.addConverter(Single.class, Observable.class, Single::toObservable);
        conversionService.addConverter(Single.class, Completable.class, Completable::fromSingle);
        conversionService.addConverter(Object.class, Single.class, Single::just);
        conversionService.addConverter(Flowable.class, Single.class, Flowable::firstOrError);
        conversionService.addConverter(Flowable.class, Maybe.class, Flowable::firstElement);
        conversionService.addConverter(Flowable.class, Observable.class, Flowable::toObservable);
        conversionService.addConverter(Flowable.class, Completable.class, Completable::fromPublisher);
        conversionService.addConverter(Object.class, Flowable.class, o -> {
            if (o instanceof Iterable) {
                return Flowable.fromIterable((Iterable)((Iterable)o));
            }
            return Flowable.just((Object)o);
        });
        conversionService.addConverter(Publisher.class, Flowable.class, publisher -> {
            if (publisher instanceof Flowable) {
                return (Flowable)publisher;
            }
            return ContextPropagatingPublisher.asFlowable(publisher);
        });
        conversionService.addConverter(Publisher.class, Single.class, ContextPropagatingPublisher::asSingle);
        conversionService.addConverter(Publisher.class, Observable.class, ContextPropagatingPublisher::asObservable);
        conversionService.addConverter(Publisher.class, Maybe.class, ContextPropagatingPublisher::asMaybe);
        conversionService.addConverter(Publisher.class, Completable.class, ContextPropagatingPublisher::asCompletable);
    }

    private static class ContextPropagatingPublisher<T>
    implements Publisher<T> {
        private final PropagatedContext context = PropagatedContext.find().orElse(null);
        private final Publisher<? extends T> actual;

        private ContextPropagatingPublisher(Publisher<? extends T> actual) {
            this.actual = actual;
        }

        public static <T> Flowable<T> asFlowable(Publisher<? extends T> actual) {
            return Flowable.fromPublisher(new ContextPropagatingPublisher<T>(actual));
        }

        public static <T> Single<T> asSingle(Publisher<? extends T> actual) {
            return Single.fromPublisher(new ContextPropagatingPublisher<T>(actual));
        }

        public static <T> Observable<T> asObservable(Publisher<? extends T> actual) {
            return Observable.fromPublisher(new ContextPropagatingPublisher<T>(actual));
        }

        public static <T> Maybe<T> asMaybe(Publisher<? extends T> actual) {
            return Maybe.fromPublisher(new ContextPropagatingPublisher<T>(actual));
        }

        public static <T> Completable asCompletable(Publisher<? extends T> actual) {
            return Completable.fromPublisher(new ContextPropagatingPublisher<T>(actual));
        }

        public void subscribe(final Subscriber<? super T> subscriber) {
            if (this.context == null) {
                this.actual.subscribe(subscriber);
            } else {
                this.executeInContext(this.context, () -> this.actual.subscribe(new Subscriber<T>(){

                    public void onSubscribe(Subscription subscription) {
                        this.executeInContext(context, () -> subscriber.onSubscribe(subscription));
                    }

                    public void onNext(T t) {
                        this.executeInContext(context, () -> subscriber.onNext(t));
                    }

                    public void onError(Throwable throwable) {
                        this.executeInContext(context, () -> subscriber.onError(throwable));
                    }

                    public void onComplete() {
                        this.executeInContext(context, () -> ((Subscriber)subscriber).onComplete());
                    }
                }));
            }
        }

        private void executeInContext(@NonNull PropagatedContext context, @NonNull Runnable runnable) {
            try (PropagatedContext.Scope ignore = context.propagate();){
                runnable.run();
            }
        }
    }
}

