/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.authentication.providers;

import io.micronaut.context.annotation.Requires;
import io.micronaut.security.authentication.AuthenticationFailed;
import io.micronaut.security.authentication.AuthenticationFailureReason;
import io.micronaut.security.authentication.AuthenticationProvider;
import io.micronaut.security.authentication.AuthenticationRequest;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.authentication.UserDetails;
import io.micronaut.security.authentication.providers.AuthoritiesFetcher;
import io.micronaut.security.authentication.providers.PasswordEncoder;
import io.micronaut.security.authentication.providers.UserFetcher;
import io.micronaut.security.authentication.providers.UserState;
import io.reactivex.Flowable;
import java.util.List;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;

@Requires(beans={UserFetcher.class, PasswordEncoder.class, AuthoritiesFetcher.class})
@Singleton
public class DelegatingAuthenticationProvider
implements AuthenticationProvider {
    protected final UserFetcher userFetcher;
    protected final PasswordEncoder passwordEncoder;
    protected final AuthoritiesFetcher authoritiesFetcher;

    public DelegatingAuthenticationProvider(UserFetcher userFetcher, PasswordEncoder passwordEncoder, AuthoritiesFetcher authoritiesFetcher) {
        this.userFetcher = userFetcher;
        this.passwordEncoder = passwordEncoder;
        this.authoritiesFetcher = authoritiesFetcher;
    }

    @Override
    public Publisher<AuthenticationResponse> authenticate(AuthenticationRequest authenticationRequest) {
        return Flowable.fromPublisher(this.fetchUserState(authenticationRequest)).switchMap(user -> {
            if (!user.isEnabled()) {
                return Flowable.just((Object)new AuthenticationFailed(AuthenticationFailureReason.USER_DISABLED));
            }
            if (user.isAccountExpired()) {
                return Flowable.just((Object)new AuthenticationFailed(AuthenticationFailureReason.ACCOUNT_EXPIRED));
            }
            if (user.isAccountLocked()) {
                return Flowable.just((Object)new AuthenticationFailed(AuthenticationFailureReason.ACCOUNT_LOCKED));
            }
            if (user.isPasswordExpired()) {
                return Flowable.just((Object)new AuthenticationFailed(AuthenticationFailureReason.PASSWORD_EXPIRED));
            }
            if (!this.passwordEncoder.matches(authenticationRequest.getSecret().toString(), user.getPassword())) {
                return Flowable.just((Object)new AuthenticationFailed(AuthenticationFailureReason.CREDENTIALS_DO_NOT_MATCH));
            }
            return this.createSuccessfulAuthenticationResponse(authenticationRequest, (UserState)user);
        }).switchIfEmpty((Publisher)Flowable.just((Object)new AuthenticationFailed(AuthenticationFailureReason.USER_NOT_FOUND)));
    }

    protected Publisher<UserState> fetchUserState(AuthenticationRequest authenticationRequest) {
        String username = authenticationRequest.getIdentity().toString();
        return this.userFetcher.findByUsername(username);
    }

    protected Publisher<AuthenticationResponse> createSuccessfulAuthenticationResponse(AuthenticationRequest authenticationRequest, UserState user) {
        return Flowable.fromPublisher(this.authoritiesFetcher.findAuthoritiesByUsername(user.getUsername())).map(authorities -> this.createSuccessfulAuthenticationResponse(authenticationRequest, user, (List<String>)authorities));
    }

    protected AuthenticationResponse createSuccessfulAuthenticationResponse(AuthenticationRequest authenticationRequest, UserState user, List<String> authorities) {
        return new UserDetails(user.getUsername(), authorities);
    }
}

