/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.config;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.security.config.InterceptUrlMapPattern;
import io.micronaut.security.config.SecurityConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@ConfigurationProperties(value="micronaut.security")
public class SecurityConfigurationProperties
implements SecurityConfiguration {
    public static final String PREFIX = "micronaut.security";
    public static final String ANYWHERE = "0.0.0.0";
    public static final boolean DEFAULT_ENABLED = false;
    private boolean enabled = false;
    private List<InterceptUrlMapPattern> interceptUrlMap = new ArrayList<InterceptUrlMapPattern>();
    private List<String> ipPatterns = Collections.singletonList("0.0.0.0");

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public List<InterceptUrlMapPattern> getInterceptUrlMap() {
        return this.interceptUrlMap;
    }

    @Override
    public List<String> getIpPatterns() {
        return this.ipPatterns;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setInterceptUrlMap(List<InterceptUrlMapPattern> interceptUrlMap) {
        if (CollectionUtils.isNotEmpty(interceptUrlMap)) {
            this.interceptUrlMap = interceptUrlMap;
        }
    }

    public void setIpPatterns(List<String> ipPatterns) {
        this.ipPatterns = ipPatterns;
    }
}

