/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.endpoints;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Post;
import io.micronaut.security.annotation.Secured;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.event.LogoutEvent;
import io.micronaut.security.handlers.LogoutHandler;
import javax.annotation.Nullable;

@Requires(property="micronaut.security.endpoints.logout.enabled")
@Controller(value="${micronaut.security.endpoints.logout.path:/logout}")
@Secured(value={"isAnonymous()"})
public class LogoutController {
    protected final LogoutHandler logoutHandler;
    protected final ApplicationEventPublisher eventPublisher;

    public LogoutController(@Nullable LogoutHandler logoutHandler, ApplicationEventPublisher eventPublisher) {
        this.logoutHandler = logoutHandler;
        this.eventPublisher = eventPublisher;
    }

    @Consumes(value={"application/x-www-form-urlencoded", "application/json"})
    @Post
    public HttpResponse index(HttpRequest<?> request, Authentication authentication) {
        this.eventPublisher.publishEvent((Object)new LogoutEvent(authentication));
        if (this.logoutHandler != null) {
            return this.logoutHandler.logout(request);
        }
        return HttpResponse.notFound();
    }
}

