/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.rules;

import io.micronaut.core.util.AntPathMatcher;
import io.micronaut.core.util.PathMatcher;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.config.InterceptUrlMapPattern;
import io.micronaut.security.rules.AbstractSecurityRule;
import io.micronaut.security.rules.SecurityRuleResult;
import io.micronaut.security.token.config.TokenConfiguration;
import io.micronaut.web.router.RouteMatch;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

abstract class InterceptUrlMapRule
extends AbstractSecurityRule {
    public static final Integer ORDER = 0;
    private final AntPathMatcher pathMatcher = PathMatcher.ANT;

    InterceptUrlMapRule(TokenConfiguration tokenConfiguration) {
        super(tokenConfiguration);
    }

    protected abstract List<InterceptUrlMapPattern> getPatternList();

    @Override
    public SecurityRuleResult check(HttpRequest request, @Nullable RouteMatch routeMatch, @Nullable Map<String, Object> claims) {
        String path = request.getUri().getPath();
        HttpMethod httpMethod = request.getMethod();
        Optional<InterceptUrlMapPattern> matchedPattern = this.getPatternList().stream().filter(p -> p.getHttpMethod().map(method -> method.equals((Object)httpMethod)).orElse(true)).filter(p -> this.pathMatcher.matches(p.getPattern(), path)).findFirst();
        return matchedPattern.map(pattern -> this.compareRoles(pattern.getAccess(), this.getRoles(claims))).orElse(SecurityRuleResult.UNKNOWN);
    }
}

