/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.rules;

import io.micronaut.http.HttpRequest;
import io.micronaut.security.config.SecurityConfiguration;
import io.micronaut.security.rules.AbstractSecurityRule;
import io.micronaut.security.rules.SecuredAnnotationRule;
import io.micronaut.security.rules.SecurityRuleResult;
import io.micronaut.security.token.config.TokenConfiguration;
import io.micronaut.web.router.RouteMatch;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Singleton;

@Singleton
public class IpPatternsRule
extends AbstractSecurityRule {
    public static final Integer ORDER = SecuredAnnotationRule.ORDER - 100;
    private final List<Pattern> patternList;

    public IpPatternsRule(TokenConfiguration tokenConfiguration, SecurityConfiguration securityConfiguration) {
        super(tokenConfiguration);
        this.patternList = securityConfiguration.getIpPatterns().stream().map(Pattern::compile).collect(Collectors.toList());
    }

    public int getOrder() {
        return ORDER;
    }

    @Override
    public SecurityRuleResult check(HttpRequest request, @Nullable RouteMatch routeMatch, @Nullable Map<String, Object> claims) {
        if (this.patternList.isEmpty()) {
            return SecurityRuleResult.UNKNOWN;
        }
        if (this.patternList.stream().anyMatch(pattern -> pattern.pattern().equals("0.0.0.0") || pattern.matcher(request.getRemoteAddress().getAddress().getHostAddress()).matches())) {
            return SecurityRuleResult.UNKNOWN;
        }
        return SecurityRuleResult.REJECTED;
    }
}

