/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.aot;

import com.nimbusds.jose.jwk.JWKSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.micronaut.aot.core.AOTContext;
import io.micronaut.aot.core.AOTModule;
import io.micronaut.aot.core.codegen.AbstractCodeGenerator;
import io.micronaut.context.ApplicationContext;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.StringUtils;
import io.micronaut.security.aot.AOTContextUtils;
import io.micronaut.security.aot.GeneratedFile;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import io.micronaut.security.token.jwt.signature.jwks.DefaultJwkSetFetcher;
import io.micronaut.security.token.jwt.signature.jwks.JwkSetFetcher;
import io.micronaut.security.token.jwt.signature.jwks.JwksClient;
import io.micronaut.security.token.jwt.signature.jwks.JwksSignatureConfiguration;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.lang.model.element.Modifier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@AOTModule(id="micronaut.security.jwks")
public class JwksFetcherCodeGenerator
extends AbstractCodeGenerator {
    public static final String SECURITY_AOT_JWKS_MODULE_ID = "micronaut.security.jwks";
    private static final ParameterizedTypeName SUPPLIER_OF_METADATA = ParameterizedTypeName.get(Supplier.class, (Type[])new Type[]{JWKSet.class});

    public void generate(@NonNull AOTContext context) {
        List<GeneratedFile> files;
        ApplicationContext applicationContext = context.getAnalyzer().getApplicationContext();
        if (!applicationContext.isRunning()) {
            applicationContext.start();
        }
        if (!(files = this.generateJavaFiles(context)).isEmpty()) {
            context.registerStaticOptimization("AotJwksFetcher", DefaultJwkSetFetcher.Optimizations.class, body -> {
                body.addStatement("$T configs = new $T()", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{TypeName.get(String.class), SUPPLIER_OF_METADATA}), ParameterizedTypeName.get((ClassName)ClassName.get(HashMap.class), (TypeName[])new TypeName[]{TypeName.get(String.class), SUPPLIER_OF_METADATA})});
                for (GeneratedFile generatedFile : files) {
                    context.registerGeneratedSourceFile(generatedFile.getJavaFile());
                    body.addStatement("configs.put($S, $T::create)", new Object[]{generatedFile.getName(), ClassName.bestGuess((String)generatedFile.getSimpleName())});
                }
                body.addStatement("return new $T(configs)", new Object[]{DefaultJwkSetFetcher.Optimizations.class});
            });
        }
    }

    @NonNull
    private Map<String, String> jwksUrls(@NonNull AOTContext context) {
        HashMap<String, String> urls = new HashMap<String, String>();
        AOTContextUtils.getBeansOfType(JwksSignatureConfiguration.class, context).forEach(config -> urls.put(config.getName(), config.getUrl()));
        AOTContextUtils.getBeansOfType(OpenIdProviderMetadata.class, context).stream().filter(metadata -> metadata.getJwksUri() != null).forEach(metadata -> urls.put(metadata.getName(), metadata.getJwksUri()));
        return urls;
    }

    private List<GeneratedFile> generateJavaFiles(@NonNull AOTContext context) {
        Map<String, String> urls = this.jwksUrls(context);
        JwksClient jwksClient = AOTContextUtils.getBean(JwksClient.class, context);
        ArrayList<GeneratedFile> result = new ArrayList<GeneratedFile>();
        int count = 0;
        for (Map.Entry<String, String> entry : urls.entrySet()) {
            Optional<GeneratedFile> generatedFile = this.generatedFile(context, jwksClient, entry.getKey(), entry.getValue(), count);
            if (!generatedFile.isPresent()) continue;
            result.add(generatedFile.get());
            ++count;
        }
        return result;
    }

    private Optional<GeneratedFile> generatedFile(AOTContext aotContext, JwksClient jwksClient, String providerName, String url, int count) {
        String json;
        Optional jwkSetOptional = Mono.from((Publisher)jwksClient.load(providerName, url)).blockOptional();
        if (jwkSetOptional.isPresent() && StringUtils.isNotEmpty((CharSequence)(json = (String)jwkSetOptional.get()))) {
            String simpleName = "Aot" + JwkSetFetcher.class.getSimpleName() + count;
            return Optional.of(new GeneratedFile(url, simpleName, this.generateJavaFile(aotContext, simpleName, json)));
        }
        return Optional.empty();
    }

    private JavaFile generateJavaFile(@NonNull AOTContext context, @NonNull String fileSimpleName, @NonNull String json) {
        return context.javaFile(TypeSpec.classBuilder((String)fileSimpleName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(this.generateMethod(json)).build());
    }

    @NonNull
    private MethodSpec generateMethod(@NonNull String json) {
        return MethodSpec.methodBuilder((String)"create").returns(JWKSet.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).beginControlFlow("try", new Object[0]).addStatement("return JWKSet.parse($S)", new Object[]{json}).nextControlFlow("catch ($T e)", new Object[]{ParseException.class}).addStatement("throw new $T(e)", new Object[]{RuntimeException.class}).endControlFlow().build();
    }
}

