/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.cookie;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.CookieConfiguration;
import io.micronaut.security.authentication.CookieBasedAuthenticationModeCondition;
import io.micronaut.security.config.RedirectConfiguration;
import io.micronaut.security.handlers.LogoutHandler;
import io.micronaut.security.token.jwt.cookie.AccessTokenCookieConfiguration;
import io.micronaut.security.token.jwt.cookie.JwtCookieConfiguration;
import io.micronaut.security.token.jwt.cookie.RefreshTokenCookieConfiguration;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Requires(condition=CookieBasedAuthenticationModeCondition.class)
@Singleton
public class JwtCookieClearerLogoutHandler
implements LogoutHandler {
    @Deprecated
    protected final JwtCookieConfiguration jwtCookieConfiguration;
    protected final String logout;
    protected final AccessTokenCookieConfiguration accessTokenCookieConfiguration;
    protected final RefreshTokenCookieConfiguration refreshTokenCookieConfiguration;

    @Deprecated
    public JwtCookieClearerLogoutHandler(JwtCookieConfiguration jwtCookieConfiguration) {
        this.jwtCookieConfiguration = jwtCookieConfiguration;
        this.accessTokenCookieConfiguration = jwtCookieConfiguration;
        this.refreshTokenCookieConfiguration = null;
        this.logout = jwtCookieConfiguration.getLogoutTargetUrl();
    }

    @Deprecated
    public JwtCookieClearerLogoutHandler(JwtCookieConfiguration jwtCookieConfiguration, RedirectConfiguration redirectConfiguration) {
        this.jwtCookieConfiguration = jwtCookieConfiguration;
        this.accessTokenCookieConfiguration = jwtCookieConfiguration;
        this.refreshTokenCookieConfiguration = null;
        this.logout = redirectConfiguration.getLogout();
    }

    @Inject
    public JwtCookieClearerLogoutHandler(AccessTokenCookieConfiguration accessTokenCookieConfiguration, RefreshTokenCookieConfiguration refreshTokenCookieConfiguration, RedirectConfiguration redirectConfiguration) {
        this.accessTokenCookieConfiguration = accessTokenCookieConfiguration;
        this.refreshTokenCookieConfiguration = refreshTokenCookieConfiguration;
        this.jwtCookieConfiguration = null;
        this.logout = redirectConfiguration.getLogout();
    }

    public MutableHttpResponse<?> logout(HttpRequest<?> request) {
        try {
            URI location = new URI(this.logout);
            MutableHttpResponse response = HttpResponse.seeOther((URI)location);
            this.clearCookie((CookieConfiguration)this.accessTokenCookieConfiguration, request, response);
            if (this.refreshTokenCookieConfiguration != null) {
                this.clearCookie((CookieConfiguration)this.refreshTokenCookieConfiguration, request, response);
            }
            return response;
        }
        catch (URISyntaxException var5) {
            return HttpResponse.serverError();
        }
    }

    private void clearCookie(CookieConfiguration cookieConfiguration, HttpRequest<?> request, MutableHttpResponse<?> response) {
        Optional cookie = request.getCookies().findCookie((CharSequence)cookieConfiguration.getCookieName());
        if (cookie.isPresent()) {
            Cookie requestCookie = (Cookie)cookie.get();
            String domain = cookieConfiguration.getCookieDomain().orElse(null);
            String path = cookieConfiguration.getCookiePath().orElse(null);
            Cookie responseCookie = Cookie.of((String)requestCookie.getName(), (String)"");
            responseCookie.maxAge(0L).domain(domain).path(path);
            response.cookie(responseCookie);
        }
    }
}

