/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.cookie;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.security.authentication.CookieBasedAuthenticationModeCondition;
import io.micronaut.security.token.jwt.cookie.AccessTokenCookieConfiguration;
import io.micronaut.security.token.jwt.cookie.JwtCookieConfiguration;
import io.micronaut.security.token.reader.TokenReader;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Requirements(value={@Requires(condition=CookieBasedAuthenticationModeCondition.class), @Requires(property="micronaut.security.token.jwt.cookie.enabled", notEquals="false", defaultValue="true")})
@Singleton
public class JwtCookieTokenReader
implements TokenReader {
    public static final Integer ORDER = 0;
    @Deprecated
    protected final JwtCookieConfiguration jwtCookieConfiguration;
    protected final AccessTokenCookieConfiguration accessTokenCookieConfiguration;

    @Deprecated
    public JwtCookieTokenReader(JwtCookieConfiguration jwtCookieConfiguration) {
        this.jwtCookieConfiguration = jwtCookieConfiguration;
        this.accessTokenCookieConfiguration = jwtCookieConfiguration;
    }

    @Inject
    public JwtCookieTokenReader(AccessTokenCookieConfiguration accessTokenCookieConfiguration) {
        this.jwtCookieConfiguration = null;
        this.accessTokenCookieConfiguration = accessTokenCookieConfiguration;
    }

    public Optional<String> findToken(HttpRequest<?> request) {
        Optional optionalCookie = request.getCookies().findCookie((CharSequence)this.accessTokenCookieConfiguration.getCookieName());
        return optionalCookie.map(Cookie::getValue);
    }

    public int getOrder() {
        return ORDER;
    }
}

